% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_search_local_gateway_routes}
\alias{ec2_search_local_gateway_routes}
\title{Searches for routes in the specified local gateway route table}
\usage{
ec2_search_local_gateway_routes(LocalGatewayRouteTableId, Filters,
  MaxResults, NextToken, DryRun)
}
\arguments{
\item{LocalGatewayRouteTableId}{[required] The ID of the local gateway route table.}

\item{Filters}{[required] One or more filters.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Searches for routes in the specified local gateway route table.
}
\section{Request syntax}{
\preformatted{svc$search_local_gateway_routes(
  LocalGatewayRouteTableId = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
