% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_ebs_encryption_by_default}
\alias{ec2_get_ebs_encryption_by_default}
\title{Describes whether EBS encryption by default is enabled for your account
in the current Region}
\usage{
ec2_get_ebs_encryption_by_default(DryRun)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes whether EBS encryption by default is enabled for your account
in the current Region.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html}{Amazon EBS Encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_ebs_encryption_by_default(
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
