% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpc_endpoints}
\alias{ec2_describe_vpc_endpoints}
\title{Describes one or more of your VPC endpoints}
\usage{
ec2_describe_vpc_endpoints(DryRun, VpcEndpointIds, Filters, MaxResults,
  NextToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcEndpointIds}{One or more endpoint IDs.}

\item{Filters}{One or more filters.
\itemize{
\item \code{service-name}: The name of the service.
\item \code{vpc-id}: The ID of the VPC in which the endpoint resides.
\item \code{vpc-endpoint-id}: The ID of the endpoint.
\item \code{vpc-endpoint-state}: The state of the endpoint. (\code{pending} \|
\code{available} \| \code{deleting} \| \code{deleted})
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}}

\item{MaxResults}{The maximum number of items to return for this request. The request
returns a token that you can specify in a subsequent call to get the
next set of results.

Constraint: If the value is greater than 1000, we return only 1000
items.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a prior call.)}
}
\description{
Describes one or more of your VPC endpoints.
}
\section{Request syntax}{
\preformatted{svc$describe_vpc_endpoints(
  DryRun = TRUE|FALSE,
  VpcEndpointIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
