% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpn_gateways}
\alias{ec2_describe_vpn_gateways}
\title{Describes one or more of your virtual private gateways}
\usage{
ec2_describe_vpn_gateways(Filters, VpnGatewayIds, DryRun)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{amazon-side-asn} - The Autonomous System Number (ASN) for the
Amazon side of the gateway.
\item \code{attachment.state} - The current state of the attachment between the
gateway and the VPC (\code{attaching} \| \code{attached} \| \code{detaching} \|
\code{detached}).
\item \code{attachment.vpc-id} - The ID of an attached VPC.
\item \code{availability-zone} - The Availability Zone for the virtual private
gateway (if applicable).
\item \code{state} - The state of the virtual private gateway (\code{pending} \|
\code{available} \| \code{deleting} \| \code{deleted}).
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{type} - The type of virtual private gateway. Currently the only
supported type is \code{ipsec.1}.
\item \code{vpn-gateway-id} - The ID of the virtual private gateway.
}}

\item{VpnGatewayIds}{One or more virtual private gateway IDs.

Default: Describes all your virtual private gateways.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes one or more of your virtual private gateways.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html}{AWS Site-to-Site VPN} in the
\emph{AWS Site-to-Site VPN User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_vpn_gateways(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  VpnGatewayIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
