% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_accept_transit_gateway_vpc_attachment}
\alias{ec2_accept_transit_gateway_vpc_attachment}
\title{Accepts a request to attach a VPC to a transit gateway}
\usage{
ec2_accept_transit_gateway_vpc_attachment(TransitGatewayAttachmentId,
  DryRun)
}
\arguments{
\item{TransitGatewayAttachmentId}{[required] The ID of the attachment.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Accepts a request to attach a VPC to a transit gateway.
}
\details{
The VPC attachment must be in the \code{pendingAcceptance} state. Use
DescribeTransitGatewayVpcAttachments to view your pending VPC attachment
requests. Use RejectTransitGatewayVpcAttachment to reject a VPC
attachment request.
}
\section{Request syntax}{
\preformatted{svc$accept_transit_gateway_vpc_attachment(
  TransitGatewayAttachmentId = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
