# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include lambda_service.R
NULL

#' Adds permissions to the resource-based policy of a version of an AWS
#' Lambda layer
#'
#' Adds permissions to the resource-based policy of a version of an [AWS
#' Lambda
#' layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
#' Use this action to grant layer usage permission to other accounts. You
#' can grant permission to a single account, all AWS accounts, or all
#' accounts in an organization.
#' 
#' To revoke permission, call RemoveLayerVersionPermission with the
#' statement ID that you specified when you added it.
#'
#' @usage
#' lambda_add_layer_version_permission(LayerName, VersionNumber,
#'   StatementId, Action, Principal, OrganizationId, RevisionId)
#'
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param VersionNumber &#91;required&#93; The version number.
#' @param StatementId &#91;required&#93; An identifier that distinguishes the policy from others on the same
#' layer version.
#' @param Action &#91;required&#93; The API action that grants access to the layer. For example,
#' `lambda:GetLayerVersion`.
#' @param Principal &#91;required&#93; An account ID, or `*` to grant permission to all AWS accounts.
#' @param OrganizationId With the principal set to `*`, grant permission to all accounts in the
#' specified organization.
#' @param RevisionId Only update the policy if the revision ID matches the ID specified. Use
#' this option to avoid modifying a policy that has changed since you last
#' read it.
#'
#' @section Request syntax:
#' ```
#' svc$add_layer_version_permission(
#'   LayerName = "string",
#'   VersionNumber = 123,
#'   StatementId = "string",
#'   Action = "string",
#'   Principal = "string",
#'   OrganizationId = "string",
#'   RevisionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_add_layer_version_permission
lambda_add_layer_version_permission <- function(LayerName, VersionNumber, StatementId, Action, Principal, OrganizationId = NULL, RevisionId = NULL) {
  op <- new_operation(
    name = "AddLayerVersionPermission",
    http_method = "POST",
    http_path = "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy",
    paginator = list()
  )
  input <- .lambda$add_layer_version_permission_input(LayerName = LayerName, VersionNumber = VersionNumber, StatementId = StatementId, Action = Action, Principal = Principal, OrganizationId = OrganizationId, RevisionId = RevisionId)
  output <- .lambda$add_layer_version_permission_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$add_layer_version_permission <- lambda_add_layer_version_permission

#' Grants an AWS service or another account permission to use a function
#'
#' Grants an AWS service or another account permission to use a function.
#' You can apply the policy at the function level, or specify a qualifier
#' to restrict access to a single version or alias. If you use a qualifier,
#' the invoker must use the full Amazon Resource Name (ARN) of that version
#' or alias to invoke the function.
#' 
#' To grant permission to another account, specify the account ID as the
#' `Principal`. For AWS services, the principal is a domain-style
#' identifier defined by the service, like `s3.amazonaws.com` or
#' `sns.amazonaws.com`. For AWS services, you can also specify the ARN or
#' owning account of the associated resource as the `SourceArn` or
#' `SourceAccount`. If you grant permission to a service principal without
#' specifying the source, other accounts could potentially configure
#' resources in their account to invoke your Lambda function.
#' 
#' This action adds a statement to a resource-based permission policy for
#' the function. For more information about function policies, see [Lambda
#' Function
#' Policies](https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html).
#'
#' @usage
#' lambda_add_permission(FunctionName, StatementId, Action, Principal,
#'   SourceArn, SourceAccount, EventSourceToken, Qualifier, RevisionId)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param StatementId &#91;required&#93; A statement identifier that differentiates the statement from others in
#' the same policy.
#' @param Action &#91;required&#93; The action that the principal can use on the function. For example,
#' `lambda:InvokeFunction` or `lambda:GetFunction`.
#' @param Principal &#91;required&#93; The AWS service or account that invokes the function. If you specify a
#' service, use `SourceArn` or `SourceAccount` to limit who can invoke the
#' function through that service.
#' @param SourceArn For AWS services, the ARN of the AWS resource that invokes the function.
#' For example, an Amazon S3 bucket or Amazon SNS topic.
#' @param SourceAccount For AWS services, the ID of the account that owns the resource. Use this
#' instead of `SourceArn` to grant permission to resources that are owned
#' by another account (for example, all of an account\'s Amazon S3
#' buckets). Or use it together with `SourceArn` to ensure that the
#' resource is owned by the specified account. For example, an Amazon S3
#' bucket could be deleted by its owner and recreated by another account.
#' @param EventSourceToken For Alexa Smart Home functions, a token that must be supplied by the
#' invoker.
#' @param Qualifier Specify a version or alias to add permissions to a published version of
#' the function.
#' @param RevisionId Only update the policy if the revision ID matches the ID that\'s
#' specified. Use this option to avoid modifying a policy that has changed
#' since you last read it.
#'
#' @section Request syntax:
#' ```
#' svc$add_permission(
#'   FunctionName = "string",
#'   StatementId = "string",
#'   Action = "string",
#'   Principal = "string",
#'   SourceArn = "string",
#'   SourceAccount = "string",
#'   EventSourceToken = "string",
#'   Qualifier = "string",
#'   RevisionId = "string"
#' )
#' ```
#'
#' @examples
#' # This example adds a permission for an S3 bucket to invoke a Lambda
#' # function.
#' \donttest{svc$add_permission(
#'   Action = "lambda:InvokeFunction",
#'   FunctionName = "MyFunction",
#'   Principal = "s3.amazonaws.com",
#'   SourceAccount = "123456789012",
#'   SourceArn = "arn:aws:s3:::examplebucket/*",
#'   StatementId = "ID-1"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_add_permission
lambda_add_permission <- function(FunctionName, StatementId, Action, Principal, SourceArn = NULL, SourceAccount = NULL, EventSourceToken = NULL, Qualifier = NULL, RevisionId = NULL) {
  op <- new_operation(
    name = "AddPermission",
    http_method = "POST",
    http_path = "/2015-03-31/functions/{FunctionName}/policy",
    paginator = list()
  )
  input <- .lambda$add_permission_input(FunctionName = FunctionName, StatementId = StatementId, Action = Action, Principal = Principal, SourceArn = SourceArn, SourceAccount = SourceAccount, EventSourceToken = EventSourceToken, Qualifier = Qualifier, RevisionId = RevisionId)
  output <- .lambda$add_permission_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$add_permission <- lambda_add_permission

#' Creates an alias for a Lambda function version
#'
#' Creates an
#' [alias](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html)
#' for a Lambda function version. Use aliases to provide clients with a
#' function identifier that you can update to invoke a different version.
#' 
#' You can also map an alias to split invocation requests between two
#' versions. Use the `RoutingConfig` parameter to specify a second version
#' and the percentage of invocation requests that it receives.
#'
#' @usage
#' lambda_create_alias(FunctionName, Name, FunctionVersion, Description,
#'   RoutingConfig)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Name &#91;required&#93; The name of the alias.
#' @param FunctionVersion &#91;required&#93; The function version that the alias invokes.
#' @param Description A description of the alias.
#' @param RoutingConfig The [routing
#' configuration](https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html)
#' of the alias.
#'
#' @section Request syntax:
#' ```
#' svc$create_alias(
#'   FunctionName = "string",
#'   Name = "string",
#'   FunctionVersion = "string",
#'   Description = "string",
#'   RoutingConfig = list(
#'     AdditionalVersionWeights = list(
#'       123.0
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_create_alias
lambda_create_alias <- function(FunctionName, Name, FunctionVersion, Description = NULL, RoutingConfig = NULL) {
  op <- new_operation(
    name = "CreateAlias",
    http_method = "POST",
    http_path = "/2015-03-31/functions/{FunctionName}/aliases",
    paginator = list()
  )
  input <- .lambda$create_alias_input(FunctionName = FunctionName, Name = Name, FunctionVersion = FunctionVersion, Description = Description, RoutingConfig = RoutingConfig)
  output <- .lambda$create_alias_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$create_alias <- lambda_create_alias

#' Creates a mapping between an event source and an AWS Lambda function
#'
#' Creates a mapping between an event source and an AWS Lambda function.
#' Lambda reads items from the event source and triggers the function.
#' 
#' For details about each event source type, see the following topics.
#' 
#' -   [Using AWS Lambda with Amazon
#'     Kinesis](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html)
#' 
#' -   [Using AWS Lambda with Amazon
#'     SQS](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html)
#' 
#' -   [Using AWS Lambda with Amazon
#'     DynamoDB](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html)
#'
#' @usage
#' lambda_create_event_source_mapping(EventSourceArn, FunctionName,
#'   Enabled, BatchSize, StartingPosition, StartingPositionTimestamp)
#'
#' @param EventSourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the event source.
#' 
#' -   **Amazon Kinesis** - The ARN of the data stream or a stream
#'     consumer.
#' 
#' -   **Amazon DynamoDB Streams** - The ARN of the stream.
#' 
#' -   **Amazon Simple Queue Service** - The ARN of the queue.
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Version or Alias ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it\'s limited to 64 characters in length.
#' @param Enabled Disables the event source mapping to pause polling and invocation.
#' @param BatchSize The maximum number of items to retrieve in a single batch.
#' 
#' -   **Amazon Kinesis** - Default 100. Max 10,000.
#' 
#' -   **Amazon DynamoDB Streams** - Default 100. Max 1,000.
#' 
#' -   **Amazon Simple Queue Service** - Default 10. Max 10.
#' @param StartingPosition The position in a stream from which to start reading. Required for
#' Amazon Kinesis and Amazon DynamoDB Streams sources. `AT_TIMESTAMP` is
#' only supported for Amazon Kinesis streams.
#' @param StartingPositionTimestamp With `StartingPosition` set to `AT_TIMESTAMP`, the time from which to
#' start reading.
#'
#' @section Request syntax:
#' ```
#' svc$create_event_source_mapping(
#'   EventSourceArn = "string",
#'   FunctionName = "string",
#'   Enabled = TRUE|FALSE,
#'   BatchSize = 123,
#'   StartingPosition = "TRIM_HORIZON"|"LATEST"|"AT_TIMESTAMP",
#'   StartingPositionTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_create_event_source_mapping
lambda_create_event_source_mapping <- function(EventSourceArn, FunctionName, Enabled = NULL, BatchSize = NULL, StartingPosition = NULL, StartingPositionTimestamp = NULL) {
  op <- new_operation(
    name = "CreateEventSourceMapping",
    http_method = "POST",
    http_path = "/2015-03-31/event-source-mappings/",
    paginator = list()
  )
  input <- .lambda$create_event_source_mapping_input(EventSourceArn = EventSourceArn, FunctionName = FunctionName, Enabled = Enabled, BatchSize = BatchSize, StartingPosition = StartingPosition, StartingPositionTimestamp = StartingPositionTimestamp)
  output <- .lambda$create_event_source_mapping_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$create_event_source_mapping <- lambda_create_event_source_mapping

#' Creates a Lambda function
#'
#' Creates a Lambda function. To create a function, you need a [deployment
#' package](https://docs.aws.amazon.com/lambda/latest/dg/deployment-package-v2.html)
#' and an [execution
#' role](https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role).
#' The deployment package contains your function code. The execution role
#' grants the function permission to use AWS services, such as Amazon
#' CloudWatch Logs for log streaming and AWS X-Ray for request tracing.
#' 
#' A function has an unpublished version, and can have published versions
#' and aliases. The unpublished version changes when you update your
#' function\'s code and configuration. A published version is a snapshot of
#' your function code and configuration that can\'t be changed. An alias is
#' a named resource that maps to a version, and can be changed to map to a
#' different version. Use the `Publish` parameter to create version `1` of
#' your function from its initial configuration.
#' 
#' The other parameters let you configure version-specific and
#' function-level settings. You can modify version-specific settings later
#' with UpdateFunctionConfiguration. Function-level settings apply to both
#' the unpublished and published versions of the function, and include tags
#' (TagResource) and per-function concurrency limits
#' (PutFunctionConcurrency).
#' 
#' If another account or an AWS service invokes your function, use
#' AddPermission to grant permission by creating a resource-based IAM
#' policy. You can grant permissions at the function level, on a version,
#' or on an alias.
#' 
#' To invoke your function directly, use Invoke. To invoke your function in
#' response to events in other AWS services, create an event source mapping
#' (CreateEventSourceMapping), or configure a function trigger in the other
#' service. For more information, see [Invoking
#' Functions](https://docs.aws.amazon.com/lambda/latest/dg/invoking-lambda-functions.html).
#'
#' @usage
#' lambda_create_function(FunctionName, Runtime, Role, Handler, Code,
#'   Description, Timeout, MemorySize, Publish, VpcConfig, DeadLetterConfig,
#'   Environment, KMSKeyArn, TracingConfig, Tags, Layers)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Runtime &#91;required&#93; The identifier of the function\'s
#' [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html).
#' @param Role &#91;required&#93; The Amazon Resource Name (ARN) of the function\'s execution role.
#' @param Handler &#91;required&#93; The name of the method within your code that Lambda calls to execute
#' your function. The format includes the file name. It can also include
#' namespaces and other qualifiers, depending on the runtime. For more
#' information, see [Programming
#' Model](https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html).
#' @param Code &#91;required&#93; The code for the function.
#' @param Description A description of the function.
#' @param Timeout The amount of time that Lambda allows a function to run before stopping
#' it. The default is 3 seconds. The maximum allowed value is 900 seconds.
#' @param MemorySize The amount of memory that your function has access to. Increasing the
#' function\'s memory also increases its CPU allocation. The default value
#' is 128 MB. The value must be a multiple of 64 MB.
#' @param Publish Set to true to publish the first version of the function during
#' creation.
#' @param VpcConfig For network connectivity to AWS resources in a VPC, specify a list of
#' security groups and subnets in the VPC. When you connect a function to a
#' VPC, it can only access resources and the internet through that VPC. For
#' more information, see [VPC
#' Settings](https://docs.aws.amazon.com/lambda/latest/dg/vpc.html).
#' @param DeadLetterConfig A dead letter queue configuration that specifies the queue or topic
#' where Lambda sends asynchronous events when they fail processing. For
#' more information, see [Dead Letter
#' Queues](https://docs.aws.amazon.com/lambda/latest/dg/dlq.html).
#' @param Environment Environment variables that are accessible from function code during
#' execution.
#' @param KMSKeyArn The ARN of the AWS Key Management Service (AWS KMS) key that\'s used to
#' encrypt your function\'s environment variables. If it\'s not provided,
#' AWS Lambda uses a default service key.
#' @param TracingConfig Set `Mode` to `Active` to sample and trace a subset of incoming requests
#' with AWS X-Ray.
#' @param Tags A list of
#' [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) to
#' apply to the function.
#' @param Layers A list of [function
#' layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
#' to add to the function\'s execution environment. Specify each layer by
#' its ARN, including the version.
#'
#' @section Request syntax:
#' ```
#' svc$create_function(
#'   FunctionName = "string",
#'   Runtime = "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"java8"|"python2.7"|"python3.6"|"python3.7"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"provided",
#'   Role = "string",
#'   Handler = "string",
#'   Code = list(
#'     ZipFile = raw,
#'     S3Bucket = "string",
#'     S3Key = "string",
#'     S3ObjectVersion = "string"
#'   ),
#'   Description = "string",
#'   Timeout = 123,
#'   MemorySize = 123,
#'   Publish = TRUE|FALSE,
#'   VpcConfig = list(
#'     SubnetIds = list(
#'       "string"
#'     ),
#'     SecurityGroupIds = list(
#'       "string"
#'     )
#'   ),
#'   DeadLetterConfig = list(
#'     TargetArn = "string"
#'   ),
#'   Environment = list(
#'     Variables = list(
#'       "string"
#'     )
#'   ),
#'   KMSKeyArn = "string",
#'   TracingConfig = list(
#'     Mode = "Active"|"PassThrough"
#'   ),
#'   Tags = list(
#'     "string"
#'   ),
#'   Layers = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example creates a Lambda function.
#' \donttest{svc$create_function(
#'   Code = structure(
#'     list(),
#'     .Names = character(
#'       0
#'     )
#'   ),
#'   Description = "",
#'   FunctionName = "MyFunction",
#'   Handler = "souce_file.handler_name",
#'   MemorySize = 128L,
#'   Publish = TRUE,
#'   Role = "arn:aws:iam::123456789012:role/service-role/role-name",
#'   Runtime = "nodejs8.10",
#'   Timeout = 15L,
#'   VpcConfig = structure(
#'     list(),
#'     .Names = character(
#'       0
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_create_function
lambda_create_function <- function(FunctionName, Runtime, Role, Handler, Code, Description = NULL, Timeout = NULL, MemorySize = NULL, Publish = NULL, VpcConfig = NULL, DeadLetterConfig = NULL, Environment = NULL, KMSKeyArn = NULL, TracingConfig = NULL, Tags = NULL, Layers = NULL) {
  op <- new_operation(
    name = "CreateFunction",
    http_method = "POST",
    http_path = "/2015-03-31/functions",
    paginator = list()
  )
  input <- .lambda$create_function_input(FunctionName = FunctionName, Runtime = Runtime, Role = Role, Handler = Handler, Code = Code, Description = Description, Timeout = Timeout, MemorySize = MemorySize, Publish = Publish, VpcConfig = VpcConfig, DeadLetterConfig = DeadLetterConfig, Environment = Environment, KMSKeyArn = KMSKeyArn, TracingConfig = TracingConfig, Tags = Tags, Layers = Layers)
  output <- .lambda$create_function_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$create_function <- lambda_create_function

#' Deletes a Lambda function alias
#'
#' Deletes a Lambda function
#' [alias](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
#'
#' @usage
#' lambda_delete_alias(FunctionName, Name)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Name &#91;required&#93; The name of the alias.
#'
#' @section Request syntax:
#' ```
#' svc$delete_alias(
#'   FunctionName = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @examples
#' # This operation deletes a Lambda function alias
#' \donttest{svc$delete_alias(
#'   FunctionName = "myFunction",
#'   Name = "alias"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_delete_alias
lambda_delete_alias <- function(FunctionName, Name) {
  op <- new_operation(
    name = "DeleteAlias",
    http_method = "DELETE",
    http_path = "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
    paginator = list()
  )
  input <- .lambda$delete_alias_input(FunctionName = FunctionName, Name = Name)
  output <- .lambda$delete_alias_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_alias <- lambda_delete_alias

#' Deletes an event source mapping
#'
#' Deletes an [event source
#' mapping](https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html).
#' You can get the identifier of a mapping from the output of
#' ListEventSourceMappings.
#'
#' @usage
#' lambda_delete_event_source_mapping(UUID)
#'
#' @param UUID &#91;required&#93; The identifier of the event source mapping.
#'
#' @section Request syntax:
#' ```
#' svc$delete_event_source_mapping(
#'   UUID = "string"
#' )
#' ```
#'
#' @examples
#' # This operation deletes a Lambda function event source mapping
#' \donttest{svc$delete_event_source_mapping(
#'   UUID = "12345kxodurf3443"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_delete_event_source_mapping
lambda_delete_event_source_mapping <- function(UUID) {
  op <- new_operation(
    name = "DeleteEventSourceMapping",
    http_method = "DELETE",
    http_path = "/2015-03-31/event-source-mappings/{UUID}",
    paginator = list()
  )
  input <- .lambda$delete_event_source_mapping_input(UUID = UUID)
  output <- .lambda$delete_event_source_mapping_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_event_source_mapping <- lambda_delete_event_source_mapping

#' Deletes a Lambda function
#'
#' Deletes a Lambda function. To delete a specific function version, use
#' the `Qualifier` parameter. Otherwise, all versions and aliases are
#' deleted.
#' 
#' To delete Lambda event source mappings that invoke a function, use
#' DeleteEventSourceMapping. For AWS services and resources that invoke
#' your function directly, delete the trigger in the service where you
#' originally configured it.
#'
#' @usage
#' lambda_delete_function(FunctionName, Qualifier)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function or version.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function` (name-only), `my-function:1` (with
#'     version).
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param Qualifier Specify a version to delete. You can\'t delete a version that\'s
#' referenced by an alias.
#'
#' @section Request syntax:
#' ```
#' svc$delete_function(
#'   FunctionName = "string",
#'   Qualifier = "string"
#' )
#' ```
#'
#' @examples
#' # This operation deletes a Lambda function
#' \donttest{svc$delete_function(
#'   FunctionName = "myFunction",
#'   Qualifier = "1"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_delete_function
lambda_delete_function <- function(FunctionName, Qualifier = NULL) {
  op <- new_operation(
    name = "DeleteFunction",
    http_method = "DELETE",
    http_path = "/2015-03-31/functions/{FunctionName}",
    paginator = list()
  )
  input <- .lambda$delete_function_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$delete_function_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_function <- lambda_delete_function

#' Removes a concurrent execution limit from a function
#'
#' Removes a concurrent execution limit from a function.
#'
#' @usage
#' lambda_delete_function_concurrency(FunctionName)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#'
#' @section Request syntax:
#' ```
#' svc$delete_function_concurrency(
#'   FunctionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_delete_function_concurrency
lambda_delete_function_concurrency <- function(FunctionName) {
  op <- new_operation(
    name = "DeleteFunctionConcurrency",
    http_method = "DELETE",
    http_path = "/2017-10-31/functions/{FunctionName}/concurrency",
    paginator = list()
  )
  input <- .lambda$delete_function_concurrency_input(FunctionName = FunctionName)
  output <- .lambda$delete_function_concurrency_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_function_concurrency <- lambda_delete_function_concurrency

#' Deletes a version of an AWS Lambda layer
#'
#' Deletes a version of an [AWS Lambda
#' layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
#' Deleted versions can no longer be viewed or added to functions. To avoid
#' breaking functions, a copy of the version remains in Lambda until no
#' functions refer to it.
#'
#' @usage
#' lambda_delete_layer_version(LayerName, VersionNumber)
#'
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param VersionNumber &#91;required&#93; The version number.
#'
#' @section Request syntax:
#' ```
#' svc$delete_layer_version(
#'   LayerName = "string",
#'   VersionNumber = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_delete_layer_version
lambda_delete_layer_version <- function(LayerName, VersionNumber) {
  op <- new_operation(
    name = "DeleteLayerVersion",
    http_method = "DELETE",
    http_path = "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}",
    paginator = list()
  )
  input <- .lambda$delete_layer_version_input(LayerName = LayerName, VersionNumber = VersionNumber)
  output <- .lambda$delete_layer_version_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$delete_layer_version <- lambda_delete_layer_version

#' Retrieves details about your account's limits and usage in an AWS Region
#'
#' Retrieves details about your account\'s
#' [limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html) and
#' usage in an AWS Region.
#'
#' @usage
#' lambda_get_account_settings()
#'
#' @section Request syntax:
#' ```
#' svc$get_account_settings()
#' ```
#'
#' @examples
#' # This operation retrieves a Lambda customer's account settings
#' \donttest{svc$get_account_settings()}
#'
#' @keywords internal
#'
#' @rdname lambda_get_account_settings
lambda_get_account_settings <- function() {
  op <- new_operation(
    name = "GetAccountSettings",
    http_method = "GET",
    http_path = "/2016-08-19/account-settings/",
    paginator = list()
  )
  input <- .lambda$get_account_settings_input()
  output <- .lambda$get_account_settings_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_account_settings <- lambda_get_account_settings

#' Returns details about a Lambda function alias
#'
#' Returns details about a Lambda function
#' [alias](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
#'
#' @usage
#' lambda_get_alias(FunctionName, Name)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Name &#91;required&#93; The name of the alias.
#'
#' @section Request syntax:
#' ```
#' svc$get_alias(
#'   FunctionName = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @examples
#' # This operation retrieves a Lambda function alias
#' \donttest{svc$get_alias(
#'   FunctionName = "myFunction",
#'   Name = "myFunctionAlias"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_get_alias
lambda_get_alias <- function(FunctionName, Name) {
  op <- new_operation(
    name = "GetAlias",
    http_method = "GET",
    http_path = "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
    paginator = list()
  )
  input <- .lambda$get_alias_input(FunctionName = FunctionName, Name = Name)
  output <- .lambda$get_alias_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_alias <- lambda_get_alias

#' Returns details about an event source mapping
#'
#' Returns details about an event source mapping. You can get the
#' identifier of a mapping from the output of ListEventSourceMappings.
#'
#' @usage
#' lambda_get_event_source_mapping(UUID)
#'
#' @param UUID &#91;required&#93; The identifier of the event source mapping.
#'
#' @section Request syntax:
#' ```
#' svc$get_event_source_mapping(
#'   UUID = "string"
#' )
#' ```
#'
#' @examples
#' # This operation retrieves a Lambda function's event source mapping
#' \donttest{svc$get_event_source_mapping(
#'   UUID = "123489-xxxxx-kdla8d89d7"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_get_event_source_mapping
lambda_get_event_source_mapping <- function(UUID) {
  op <- new_operation(
    name = "GetEventSourceMapping",
    http_method = "GET",
    http_path = "/2015-03-31/event-source-mappings/{UUID}",
    paginator = list()
  )
  input <- .lambda$get_event_source_mapping_input(UUID = UUID)
  output <- .lambda$get_event_source_mapping_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_event_source_mapping <- lambda_get_event_source_mapping

#' Returns information about the function or function version, with a link
#' to download the deployment package that's valid for 10 minutes
#'
#' Returns information about the function or function version, with a link
#' to download the deployment package that\'s valid for 10 minutes. If you
#' specify a function version, only details that are specific to that
#' version are returned.
#'
#' @usage
#' lambda_get_function(FunctionName, Qualifier)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param Qualifier Specify a version or alias to get details about a published version of
#' the function.
#'
#' @section Request syntax:
#' ```
#' svc$get_function(
#'   FunctionName = "string",
#'   Qualifier = "string"
#' )
#' ```
#'
#' @examples
#' # This operation retrieves a Lambda function's event source mapping
#' \donttest{svc$get_function(
#'   FunctionName = "myFunction",
#'   Qualifier = "1"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_get_function
lambda_get_function <- function(FunctionName, Qualifier = NULL) {
  op <- new_operation(
    name = "GetFunction",
    http_method = "GET",
    http_path = "/2015-03-31/functions/{FunctionName}",
    paginator = list()
  )
  input <- .lambda$get_function_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$get_function_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_function <- lambda_get_function

#' Returns the version-specific settings of a Lambda function or version
#'
#' Returns the version-specific settings of a Lambda function or version.
#' The output includes only options that can vary between versions of a
#' function. To modify these settings, use UpdateFunctionConfiguration.
#' 
#' To get all of a function\'s details, including function-level settings,
#' use GetFunction.
#'
#' @usage
#' lambda_get_function_configuration(FunctionName, Qualifier)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param Qualifier Specify a version or alias to get details about a published version of
#' the function.
#'
#' @section Request syntax:
#' ```
#' svc$get_function_configuration(
#'   FunctionName = "string",
#'   Qualifier = "string"
#' )
#' ```
#'
#' @examples
#' # This operation retrieves a Lambda function's event source mapping
#' \donttest{svc$get_function_configuration(
#'   FunctionName = "myFunction",
#'   Qualifier = "1"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_get_function_configuration
lambda_get_function_configuration <- function(FunctionName, Qualifier = NULL) {
  op <- new_operation(
    name = "GetFunctionConfiguration",
    http_method = "GET",
    http_path = "/2015-03-31/functions/{FunctionName}/configuration",
    paginator = list()
  )
  input <- .lambda$get_function_configuration_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$get_function_configuration_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_function_configuration <- lambda_get_function_configuration

#' Returns information about a version of an AWS Lambda layer, with a link
#' to download the layer archive that's valid for 10 minutes
#'
#' Returns information about a version of an [AWS Lambda
#' layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html),
#' with a link to download the layer archive that\'s valid for 10 minutes.
#'
#' @usage
#' lambda_get_layer_version(LayerName, VersionNumber)
#'
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param VersionNumber &#91;required&#93; The version number.
#'
#' @section Request syntax:
#' ```
#' svc$get_layer_version(
#'   LayerName = "string",
#'   VersionNumber = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_get_layer_version
lambda_get_layer_version <- function(LayerName, VersionNumber) {
  op <- new_operation(
    name = "GetLayerVersion",
    http_method = "GET",
    http_path = "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}",
    paginator = list()
  )
  input <- .lambda$get_layer_version_input(LayerName = LayerName, VersionNumber = VersionNumber)
  output <- .lambda$get_layer_version_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_layer_version <- lambda_get_layer_version

#' Returns information about a version of an AWS Lambda layer, with a link
#' to download the layer archive that's valid for 10 minutes
#'
#' Returns information about a version of an [AWS Lambda
#' layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html),
#' with a link to download the layer archive that\'s valid for 10 minutes.
#'
#' @usage
#' lambda_get_layer_version_by_arn(Arn)
#'
#' @param Arn &#91;required&#93; The ARN of the layer version.
#'
#' @section Request syntax:
#' ```
#' svc$get_layer_version_by_arn(
#'   Arn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_get_layer_version_by_arn
lambda_get_layer_version_by_arn <- function(Arn) {
  op <- new_operation(
    name = "GetLayerVersionByArn",
    http_method = "GET",
    http_path = "/2018-10-31/layers?find=LayerVersion",
    paginator = list()
  )
  input <- .lambda$get_layer_version_by_arn_input(Arn = Arn)
  output <- .lambda$get_layer_version_by_arn_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_layer_version_by_arn <- lambda_get_layer_version_by_arn

#' Returns the permission policy for a version of an AWS Lambda layer
#'
#' Returns the permission policy for a version of an [AWS Lambda
#' layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
#' For more information, see AddLayerVersionPermission.
#'
#' @usage
#' lambda_get_layer_version_policy(LayerName, VersionNumber)
#'
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param VersionNumber &#91;required&#93; The version number.
#'
#' @section Request syntax:
#' ```
#' svc$get_layer_version_policy(
#'   LayerName = "string",
#'   VersionNumber = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_get_layer_version_policy
lambda_get_layer_version_policy <- function(LayerName, VersionNumber) {
  op <- new_operation(
    name = "GetLayerVersionPolicy",
    http_method = "GET",
    http_path = "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy",
    paginator = list()
  )
  input <- .lambda$get_layer_version_policy_input(LayerName = LayerName, VersionNumber = VersionNumber)
  output <- .lambda$get_layer_version_policy_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_layer_version_policy <- lambda_get_layer_version_policy

#' Returns the resource-based IAM policy for a function, version, or alias
#'
#' Returns the [resource-based IAM
#' policy](https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html)
#' for a function, version, or alias.
#'
#' @usage
#' lambda_get_policy(FunctionName, Qualifier)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param Qualifier Specify a version or alias to get the policy for that resource.
#'
#' @section Request syntax:
#' ```
#' svc$get_policy(
#'   FunctionName = "string",
#'   Qualifier = "string"
#' )
#' ```
#'
#' @examples
#' # This operation retrieves a Lambda function policy
#' \donttest{svc$get_policy(
#'   FunctionName = "myFunction",
#'   Qualifier = "1"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_get_policy
lambda_get_policy <- function(FunctionName, Qualifier = NULL) {
  op <- new_operation(
    name = "GetPolicy",
    http_method = "GET",
    http_path = "/2015-03-31/functions/{FunctionName}/policy",
    paginator = list()
  )
  input <- .lambda$get_policy_input(FunctionName = FunctionName, Qualifier = Qualifier)
  output <- .lambda$get_policy_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$get_policy <- lambda_get_policy

#' Invokes a Lambda function
#'
#' Invokes a Lambda function. You can invoke a function synchronously (and
#' wait for the response), or asynchronously. To invoke a function
#' asynchronously, set `InvocationType` to `Event`.
#' 
#' For synchronous invocation, details about the function response,
#' including errors, are included in the response body and headers. For
#' either invocation type, you can find more information in the [execution
#' log](https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html)
#' and [trace](https://docs.aws.amazon.com/lambda/latest/dg/dlq.html). To
#' record function errors for asynchronous invocations, configure your
#' function with a [dead letter
#' queue](https://docs.aws.amazon.com/lambda/latest/dg/dlq.html).
#' 
#' When an error occurs, your function may be invoked multiple times. Retry
#' behavior varies by error type, client, event source, and invocation
#' type. For example, if you invoke a function asynchronously and it
#' returns an error, Lambda executes the function up to two more times. For
#' more information, see [Retry
#' Behavior](https://docs.aws.amazon.com/lambda/latest/dg/retries-on-errors.html).
#' 
#' The status code in the API response doesn\'t reflect function errors.
#' Error codes are reserved for errors that prevent your function from
#' executing, such as permissions errors, [limit
#' errors](https://docs.aws.amazon.com/lambda/latest/dg/limits.html), or
#' issues with your function\'s code and configuration. For example, Lambda
#' returns `TooManyRequestsException` if executing the function would cause
#' you to exceed a concurrency limit at either the account level
#' (`ConcurrentInvocationLimitExceeded`) or function level
#' (`ReservedFunctionConcurrentInvocationLimitExceeded`).
#' 
#' For functions with a long timeout, your client might be disconnected
#' during synchronous invocation while it waits for a response. Configure
#' your HTTP client, SDK, firewall, proxy, or operating system to allow for
#' long connections with timeout or keep-alive settings.
#' 
#' This operation requires permission for the `lambda:InvokeFunction`
#' action.
#'
#' @usage
#' lambda_invoke(FunctionName, InvocationType, LogType, ClientContext,
#'   Payload, Qualifier)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param InvocationType Choose from the following options.
#' 
#' -   `RequestResponse` (default) - Invoke the function synchronously.
#'     Keep the connection open until the function returns a response or
#'     times out. The API response includes the function response and
#'     additional data.
#' 
#' -   `Event` - Invoke the function asynchronously. Send events that fail
#'     multiple times to the function\'s dead-letter queue (if it\'s
#'     configured). The API response only includes a status code.
#' 
#' -   `DryRun` - Validate parameter values and verify that the user or
#'     role has permission to invoke the function.
#' @param LogType Set to `Tail` to include the execution log in the response.
#' @param ClientContext Up to 3583 bytes of base64-encoded data about the invoking client to
#' pass to the function in the context object.
#' @param Payload The JSON that you want to provide to your Lambda function as input.
#' @param Qualifier Specify a version or alias to invoke a published version of the
#' function.
#'
#' @section Request syntax:
#' ```
#' svc$invoke(
#'   FunctionName = "string",
#'   InvocationType = "Event"|"RequestResponse"|"DryRun",
#'   LogType = "None"|"Tail",
#'   ClientContext = "string",
#'   Payload = raw,
#'   Qualifier = "string"
#' )
#' ```
#'
#' @examples
#' # This operation invokes a Lambda function
#' \donttest{svc$invoke(
#'   ClientContext = "MyApp",
#'   FunctionName = "MyFunction",
#'   InvocationType = "Event",
#'   LogType = "Tail",
#'   Payload = "fileb://file-path/input.json",
#'   Qualifier = "1"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_invoke
lambda_invoke <- function(FunctionName, InvocationType = NULL, LogType = NULL, ClientContext = NULL, Payload = NULL, Qualifier = NULL) {
  op <- new_operation(
    name = "Invoke",
    http_method = "POST",
    http_path = "/2015-03-31/functions/{FunctionName}/invocations",
    paginator = list()
  )
  input <- .lambda$invoke_input(FunctionName = FunctionName, InvocationType = InvocationType, LogType = LogType, ClientContext = ClientContext, Payload = Payload, Qualifier = Qualifier)
  output <- .lambda$invoke_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$invoke <- lambda_invoke

#' For asynchronous function invocation, use Invoke
#'
#' For asynchronous function invocation, use Invoke.
#' 
#' Invokes a function asynchronously.
#'
#' @usage
#' lambda_invoke_async(FunctionName, InvokeArgs)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param InvokeArgs &#91;required&#93; The JSON that you want to provide to your Lambda function as input.
#'
#' @section Request syntax:
#' ```
#' svc$invoke_async(
#'   FunctionName = "string",
#'   InvokeArgs = raw
#' )
#' ```
#'
#' @examples
#' # This operation invokes a Lambda function asynchronously
#' \donttest{svc$invoke_async(
#'   FunctionName = "myFunction",
#'   InvokeArgs = "fileb://file-path/input.json"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_invoke_async
lambda_invoke_async <- function(FunctionName, InvokeArgs) {
  op <- new_operation(
    name = "InvokeAsync",
    http_method = "POST",
    http_path = "/2014-11-13/functions/{FunctionName}/invoke-async/",
    paginator = list()
  )
  input <- .lambda$invoke_async_input(FunctionName = FunctionName, InvokeArgs = InvokeArgs)
  output <- .lambda$invoke_async_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$invoke_async <- lambda_invoke_async

#' Returns a list of aliases for a Lambda function
#'
#' Returns a list of
#' [aliases](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html)
#' for a Lambda function.
#'
#' @usage
#' lambda_list_aliases(FunctionName, FunctionVersion, Marker, MaxItems)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param FunctionVersion Specify a function version to only list aliases that invoke that
#' version.
#' @param Marker Specify the pagination token that\'s returned by a previous request to
#' retrieve the next page of results.
#' @param MaxItems Limit the number of aliases returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_aliases(
#'   FunctionName = "string",
#'   FunctionVersion = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # This operation retrieves a Lambda function's aliases
#' \donttest{svc$list_aliases(
#'   FunctionName = "myFunction",
#'   FunctionVersion = "1",
#'   Marker = "",
#'   MaxItems = 123L
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_list_aliases
lambda_list_aliases <- function(FunctionName, FunctionVersion = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListAliases",
    http_method = "GET",
    http_path = "/2015-03-31/functions/{FunctionName}/aliases",
    paginator = list()
  )
  input <- .lambda$list_aliases_input(FunctionName = FunctionName, FunctionVersion = FunctionVersion, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_aliases_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_aliases <- lambda_list_aliases

#' Lists event source mappings
#'
#' Lists event source mappings. Specify an `EventSourceArn` to only show
#' event source mappings for a single event source.
#'
#' @usage
#' lambda_list_event_source_mappings(EventSourceArn, FunctionName, Marker,
#'   MaxItems)
#'
#' @param EventSourceArn The Amazon Resource Name (ARN) of the event source.
#' 
#' -   **Amazon Kinesis** - The ARN of the data stream or a stream
#'     consumer.
#' 
#' -   **Amazon DynamoDB Streams** - The ARN of the stream.
#' 
#' -   **Amazon Simple Queue Service** - The ARN of the queue.
#' @param FunctionName The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Version or Alias ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it\'s limited to 64 characters in length.
#' @param Marker A pagination token returned by a previous call.
#' @param MaxItems The maximum number of event source mappings to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_event_source_mappings(
#'   EventSourceArn = "string",
#'   FunctionName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_list_event_source_mappings
lambda_list_event_source_mappings <- function(EventSourceArn = NULL, FunctionName = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListEventSourceMappings",
    http_method = "GET",
    http_path = "/2015-03-31/event-source-mappings/",
    paginator = list()
  )
  input <- .lambda$list_event_source_mappings_input(EventSourceArn = EventSourceArn, FunctionName = FunctionName, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_event_source_mappings_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_event_source_mappings <- lambda_list_event_source_mappings

#' Returns a list of Lambda functions, with the version-specific
#' configuration of each
#'
#' Returns a list of Lambda functions, with the version-specific
#' configuration of each.
#' 
#' Set `FunctionVersion` to `ALL` to include all published versions of each
#' function in addition to the unpublished version. To get more information
#' about a function or version, use GetFunction.
#'
#' @usage
#' lambda_list_functions(MasterRegion, FunctionVersion, Marker, MaxItems)
#'
#' @param MasterRegion For Lambda\\@Edge functions, the AWS Region of the master function. For
#' example, `us-east-2` or `ALL`. If specified, you must set
#' `FunctionVersion` to `ALL`.
#' @param FunctionVersion Set to `ALL` to include entries for all published versions of each
#' function.
#' @param Marker Specify the pagination token that\'s returned by a previous request to
#' retrieve the next page of results.
#' @param MaxItems Specify a value between 1 and 50 to limit the number of functions in the
#' response.
#'
#' @section Request syntax:
#' ```
#' svc$list_functions(
#'   MasterRegion = "string",
#'   FunctionVersion = "ALL",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # This operation retrieves a Lambda functions
#' \donttest{svc$list_functions(
#'   Marker = "",
#'   MaxItems = 123L
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_list_functions
lambda_list_functions <- function(MasterRegion = NULL, FunctionVersion = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListFunctions",
    http_method = "GET",
    http_path = "/2015-03-31/functions/",
    paginator = list()
  )
  input <- .lambda$list_functions_input(MasterRegion = MasterRegion, FunctionVersion = FunctionVersion, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_functions_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_functions <- lambda_list_functions

#' Lists the versions of an AWS Lambda layer
#'
#' Lists the versions of an [AWS Lambda
#' layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
#' Versions that have been deleted aren\'t listed. Specify a [runtime
#' identifier](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html)
#' to list only versions that indicate that they\'re compatible with that
#' runtime.
#'
#' @usage
#' lambda_list_layer_versions(CompatibleRuntime, LayerName, Marker,
#'   MaxItems)
#'
#' @param CompatibleRuntime A runtime identifier. For example, `go1.x`.
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param Marker A pagination token returned by a previous call.
#' @param MaxItems The maximum number of versions to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_layer_versions(
#'   CompatibleRuntime = "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"java8"|"python2.7"|"python3.6"|"python3.7"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"provided",
#'   LayerName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_list_layer_versions
lambda_list_layer_versions <- function(CompatibleRuntime = NULL, LayerName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListLayerVersions",
    http_method = "GET",
    http_path = "/2018-10-31/layers/{LayerName}/versions",
    paginator = list()
  )
  input <- .lambda$list_layer_versions_input(CompatibleRuntime = CompatibleRuntime, LayerName = LayerName, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_layer_versions_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_layer_versions <- lambda_list_layer_versions

#' Lists AWS Lambda layers and shows information about the latest version
#' of each
#'
#' Lists [AWS Lambda
#' layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
#' and shows information about the latest version of each. Specify a
#' [runtime
#' identifier](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html)
#' to list only layers that indicate that they\'re compatible with that
#' runtime.
#'
#' @usage
#' lambda_list_layers(CompatibleRuntime, Marker, MaxItems)
#'
#' @param CompatibleRuntime A runtime identifier. For example, `go1.x`.
#' @param Marker A pagination token returned by a previous call.
#' @param MaxItems The maximum number of layers to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_layers(
#'   CompatibleRuntime = "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"java8"|"python2.7"|"python3.6"|"python3.7"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"provided",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_list_layers
lambda_list_layers <- function(CompatibleRuntime = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListLayers",
    http_method = "GET",
    http_path = "/2018-10-31/layers",
    paginator = list()
  )
  input <- .lambda$list_layers_input(CompatibleRuntime = CompatibleRuntime, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_layers_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_layers <- lambda_list_layers

#' Returns a function's tags
#'
#' Returns a function\'s
#' [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html). You
#' can also view tags with GetFunction.
#'
#' @usage
#' lambda_list_tags(Resource)
#'
#' @param Resource &#91;required&#93; The function\'s Amazon Resource Name (ARN).
#'
#' @section Request syntax:
#' ```
#' svc$list_tags(
#'   Resource = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_list_tags
lambda_list_tags <- function(Resource) {
  op <- new_operation(
    name = "ListTags",
    http_method = "GET",
    http_path = "/2017-03-31/tags/{ARN}",
    paginator = list()
  )
  input <- .lambda$list_tags_input(Resource = Resource)
  output <- .lambda$list_tags_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_tags <- lambda_list_tags

#' Returns a list of versions, with the version-specific configuration of
#' each
#'
#' Returns a list of
#' [versions](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html),
#' with the version-specific configuration of each.
#'
#' @usage
#' lambda_list_versions_by_function(FunctionName, Marker, MaxItems)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Marker Specify the pagination token that\'s returned by a previous request to
#' retrieve the next page of results.
#' @param MaxItems Limit the number of versions that are returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_versions_by_function(
#'   FunctionName = "string",
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' # This operation retrieves a Lambda function versions
#' \donttest{svc$list_versions_by_function(
#'   FunctionName = "myFunction",
#'   Marker = "",
#'   MaxItems = 123L
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_list_versions_by_function
lambda_list_versions_by_function <- function(FunctionName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListVersionsByFunction",
    http_method = "GET",
    http_path = "/2015-03-31/functions/{FunctionName}/versions",
    paginator = list()
  )
  input <- .lambda$list_versions_by_function_input(FunctionName = FunctionName, Marker = Marker, MaxItems = MaxItems)
  output <- .lambda$list_versions_by_function_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$list_versions_by_function <- lambda_list_versions_by_function

#' Creates an AWS Lambda layer from a ZIP archive
#'
#' Creates an [AWS Lambda
#' layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
#' from a ZIP archive. Each time you call `PublishLayerVersion` with the
#' same version name, a new version is created.
#' 
#' Add layers to your function with CreateFunction or
#' UpdateFunctionConfiguration.
#'
#' @usage
#' lambda_publish_layer_version(LayerName, Description, Content,
#'   CompatibleRuntimes, LicenseInfo)
#'
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param Description The description of the version.
#' @param Content &#91;required&#93; The function layer archive.
#' @param CompatibleRuntimes A list of compatible [function
#' runtimes](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html).
#' Used for filtering with ListLayers and ListLayerVersions.
#' @param LicenseInfo The layer\'s software license. It can be any of the following:
#' 
#' -   An [SPDX license identifier](https://spdx.org/licenses/). For
#'     example, `MIT`.
#' 
#' -   The URL of a license hosted on the internet. For example,
#'     `https://opensource.org/licenses/MIT`.
#' 
#' -   The full text of the license.
#'
#' @section Request syntax:
#' ```
#' svc$publish_layer_version(
#'   LayerName = "string",
#'   Description = "string",
#'   Content = list(
#'     S3Bucket = "string",
#'     S3Key = "string",
#'     S3ObjectVersion = "string",
#'     ZipFile = raw
#'   ),
#'   CompatibleRuntimes = list(
#'     "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"java8"|"python2.7"|"python3.6"|"python3.7"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"provided"
#'   ),
#'   LicenseInfo = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_publish_layer_version
lambda_publish_layer_version <- function(LayerName, Description = NULL, Content, CompatibleRuntimes = NULL, LicenseInfo = NULL) {
  op <- new_operation(
    name = "PublishLayerVersion",
    http_method = "POST",
    http_path = "/2018-10-31/layers/{LayerName}/versions",
    paginator = list()
  )
  input <- .lambda$publish_layer_version_input(LayerName = LayerName, Description = Description, Content = Content, CompatibleRuntimes = CompatibleRuntimes, LicenseInfo = LicenseInfo)
  output <- .lambda$publish_layer_version_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$publish_layer_version <- lambda_publish_layer_version

#' Creates a version from the current code and configuration of a function
#'
#' Creates a
#' [version](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html)
#' from the current code and configuration of a function. Use versions to
#' create a snapshot of your function code and configuration that doesn\'t
#' change.
#' 
#' AWS Lambda doesn\'t publish a version if the function\'s configuration
#' and code haven\'t changed since the last version. Use UpdateFunctionCode
#' or UpdateFunctionConfiguration to update the function before publishing
#' a version.
#' 
#' Clients can invoke versions directly or with an alias. To create an
#' alias, use CreateAlias.
#'
#' @usage
#' lambda_publish_version(FunctionName, CodeSha256, Description,
#'   RevisionId)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param CodeSha256 Only publish a version if the hash value matches the value that\'s
#' specified. Use this option to avoid publishing a version if the function
#' code has changed since you last updated it. You can get the hash for the
#' version that you uploaded from the output of UpdateFunctionCode.
#' @param Description A description for the version to override the description in the
#' function configuration.
#' @param RevisionId Only update the function if the revision ID matches the ID that\'s
#' specified. Use this option to avoid publishing a version if the function
#' configuration has changed since you last updated it.
#'
#' @section Request syntax:
#' ```
#' svc$publish_version(
#'   FunctionName = "string",
#'   CodeSha256 = "string",
#'   Description = "string",
#'   RevisionId = "string"
#' )
#' ```
#'
#' @examples
#' # This operation publishes a version of a Lambda function
#' \donttest{svc$publish_version(
#'   CodeSha256 = "",
#'   Description = "",
#'   FunctionName = "myFunction"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_publish_version
lambda_publish_version <- function(FunctionName, CodeSha256 = NULL, Description = NULL, RevisionId = NULL) {
  op <- new_operation(
    name = "PublishVersion",
    http_method = "POST",
    http_path = "/2015-03-31/functions/{FunctionName}/versions",
    paginator = list()
  )
  input <- .lambda$publish_version_input(FunctionName = FunctionName, CodeSha256 = CodeSha256, Description = Description, RevisionId = RevisionId)
  output <- .lambda$publish_version_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$publish_version <- lambda_publish_version

#' Sets the maximum number of simultaneous executions for a function, and
#' reserves capacity for that concurrency level
#'
#' Sets the maximum number of simultaneous executions for a function, and
#' reserves capacity for that concurrency level.
#' 
#' Concurrency settings apply to the function as a whole, including all
#' published versions and the unpublished version. Reserving concurrency
#' both ensures that your function has capacity to process the specified
#' number of events simultaneously, and prevents it from scaling beyond
#' that level. Use GetFunction to see the current setting for a function.
#' 
#' Use GetAccountSettings to see your regional concurrency limit. You can
#' reserve concurrency for as many functions as you like, as long as you
#' leave at least 100 simultaneous executions unreserved for functions that
#' aren\'t configured with a per-function limit. For more information, see
#' [Managing
#' Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
#'
#' @usage
#' lambda_put_function_concurrency(FunctionName,
#'   ReservedConcurrentExecutions)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param ReservedConcurrentExecutions &#91;required&#93; The number of simultaneous executions to reserve for the function.
#'
#' @section Request syntax:
#' ```
#' svc$put_function_concurrency(
#'   FunctionName = "string",
#'   ReservedConcurrentExecutions = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_put_function_concurrency
lambda_put_function_concurrency <- function(FunctionName, ReservedConcurrentExecutions) {
  op <- new_operation(
    name = "PutFunctionConcurrency",
    http_method = "PUT",
    http_path = "/2017-10-31/functions/{FunctionName}/concurrency",
    paginator = list()
  )
  input <- .lambda$put_function_concurrency_input(FunctionName = FunctionName, ReservedConcurrentExecutions = ReservedConcurrentExecutions)
  output <- .lambda$put_function_concurrency_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$put_function_concurrency <- lambda_put_function_concurrency

#' Removes a statement from the permissions policy for a version of an AWS
#' Lambda layer
#'
#' Removes a statement from the permissions policy for a version of an [AWS
#' Lambda
#' layer](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
#' For more information, see AddLayerVersionPermission.
#'
#' @usage
#' lambda_remove_layer_version_permission(LayerName, VersionNumber,
#'   StatementId, RevisionId)
#'
#' @param LayerName &#91;required&#93; The name or Amazon Resource Name (ARN) of the layer.
#' @param VersionNumber &#91;required&#93; The version number.
#' @param StatementId &#91;required&#93; The identifier that was specified when the statement was added.
#' @param RevisionId Only update the policy if the revision ID matches the ID specified. Use
#' this option to avoid modifying a policy that has changed since you last
#' read it.
#'
#' @section Request syntax:
#' ```
#' svc$remove_layer_version_permission(
#'   LayerName = "string",
#'   VersionNumber = 123,
#'   StatementId = "string",
#'   RevisionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_remove_layer_version_permission
lambda_remove_layer_version_permission <- function(LayerName, VersionNumber, StatementId, RevisionId = NULL) {
  op <- new_operation(
    name = "RemoveLayerVersionPermission",
    http_method = "DELETE",
    http_path = "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy/{StatementId}",
    paginator = list()
  )
  input <- .lambda$remove_layer_version_permission_input(LayerName = LayerName, VersionNumber = VersionNumber, StatementId = StatementId, RevisionId = RevisionId)
  output <- .lambda$remove_layer_version_permission_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$remove_layer_version_permission <- lambda_remove_layer_version_permission

#' Revokes function-use permission from an AWS service or another account
#'
#' Revokes function-use permission from an AWS service or another account.
#' You can get the ID of the statement from the output of GetPolicy.
#'
#' @usage
#' lambda_remove_permission(FunctionName, StatementId, Qualifier,
#'   RevisionId)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function, version, or alias.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function` (name-only), `my-function:v1`
#'     (with alias).
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' You can append a version number or alias to any of the formats. The
#' length constraint applies only to the full ARN. If you specify only the
#' function name, it is limited to 64 characters in length.
#' @param StatementId &#91;required&#93; Statement ID of the permission to remove.
#' @param Qualifier Specify a version or alias to remove permissions from a published
#' version of the function.
#' @param RevisionId Only update the policy if the revision ID matches the ID that\'s
#' specified. Use this option to avoid modifying a policy that has changed
#' since you last read it.
#'
#' @section Request syntax:
#' ```
#' svc$remove_permission(
#'   FunctionName = "string",
#'   StatementId = "string",
#'   Qualifier = "string",
#'   RevisionId = "string"
#' )
#' ```
#'
#' @examples
#' # This operation removes a Lambda function's permissions
#' \donttest{svc$remove_permission(
#'   FunctionName = "myFunction",
#'   Qualifier = "1",
#'   StatementId = "role-statement-id"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_remove_permission
lambda_remove_permission <- function(FunctionName, StatementId, Qualifier = NULL, RevisionId = NULL) {
  op <- new_operation(
    name = "RemovePermission",
    http_method = "DELETE",
    http_path = "/2015-03-31/functions/{FunctionName}/policy/{StatementId}",
    paginator = list()
  )
  input <- .lambda$remove_permission_input(FunctionName = FunctionName, StatementId = StatementId, Qualifier = Qualifier, RevisionId = RevisionId)
  output <- .lambda$remove_permission_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$remove_permission <- lambda_remove_permission

#' Adds tags to a function
#'
#' Adds [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
#' to a function.
#'
#' @usage
#' lambda_tag_resource(Resource, Tags)
#'
#' @param Resource &#91;required&#93; The function\'s Amazon Resource Name (ARN).
#' @param Tags &#91;required&#93; A list of tags to apply to the function.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   Resource = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_tag_resource
lambda_tag_resource <- function(Resource, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/2017-03-31/tags/{ARN}",
    paginator = list()
  )
  input <- .lambda$tag_resource_input(Resource = Resource, Tags = Tags)
  output <- .lambda$tag_resource_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$tag_resource <- lambda_tag_resource

#' Removes tags from a function
#'
#' Removes
#' [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) from a
#' function.
#'
#' @usage
#' lambda_untag_resource(Resource, TagKeys)
#'
#' @param Resource &#91;required&#93; The function\'s Amazon Resource Name (ARN).
#' @param TagKeys &#91;required&#93; A list of tag keys to remove from the function.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   Resource = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lambda_untag_resource
lambda_untag_resource <- function(Resource, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/2017-03-31/tags/{ARN}",
    paginator = list()
  )
  input <- .lambda$untag_resource_input(Resource = Resource, TagKeys = TagKeys)
  output <- .lambda$untag_resource_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$untag_resource <- lambda_untag_resource

#' Updates the configuration of a Lambda function alias
#'
#' Updates the configuration of a Lambda function
#' [alias](https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
#'
#' @usage
#' lambda_update_alias(FunctionName, Name, FunctionVersion, Description,
#'   RoutingConfig, RevisionId)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Name &#91;required&#93; The name of the alias.
#' @param FunctionVersion The function version that the alias invokes.
#' @param Description A description of the alias.
#' @param RoutingConfig The [routing
#' configuration](https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html)
#' of the alias.
#' @param RevisionId Only update the alias if the revision ID matches the ID that\'s
#' specified. Use this option to avoid modifying an alias that has changed
#' since you last read it.
#'
#' @section Request syntax:
#' ```
#' svc$update_alias(
#'   FunctionName = "string",
#'   Name = "string",
#'   FunctionVersion = "string",
#'   Description = "string",
#'   RoutingConfig = list(
#'     AdditionalVersionWeights = list(
#'       123.0
#'     )
#'   ),
#'   RevisionId = "string"
#' )
#' ```
#'
#' @examples
#' # This operation updates a Lambda function alias
#' \donttest{svc$update_alias(
#'   Description = "",
#'   FunctionName = "myFunction",
#'   FunctionVersion = "1",
#'   Name = "functionAlias"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_update_alias
lambda_update_alias <- function(FunctionName, Name, FunctionVersion = NULL, Description = NULL, RoutingConfig = NULL, RevisionId = NULL) {
  op <- new_operation(
    name = "UpdateAlias",
    http_method = "PUT",
    http_path = "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
    paginator = list()
  )
  input <- .lambda$update_alias_input(FunctionName = FunctionName, Name = Name, FunctionVersion = FunctionVersion, Description = Description, RoutingConfig = RoutingConfig, RevisionId = RevisionId)
  output <- .lambda$update_alias_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$update_alias <- lambda_update_alias

#' Updates an event source mapping
#'
#' Updates an event source mapping. You can change the function that AWS
#' Lambda invokes, or pause invocation and resume later from the same
#' location.
#'
#' @usage
#' lambda_update_event_source_mapping(UUID, FunctionName, Enabled,
#'   BatchSize)
#'
#' @param UUID &#91;required&#93; The identifier of the event source mapping.
#' @param FunctionName The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `MyFunction`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction`.
#' 
#' -   **Version or Alias ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD`.
#' 
#' -   **Partial ARN** - `123456789012:function:MyFunction`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it\'s limited to 64 characters in length.
#' @param Enabled Disables the event source mapping to pause polling and invocation.
#' @param BatchSize The maximum number of items to retrieve in a single batch.
#' 
#' -   **Amazon Kinesis** - Default 100. Max 10,000.
#' 
#' -   **Amazon DynamoDB Streams** - Default 100. Max 1,000.
#' 
#' -   **Amazon Simple Queue Service** - Default 10. Max 10.
#'
#' @section Request syntax:
#' ```
#' svc$update_event_source_mapping(
#'   UUID = "string",
#'   FunctionName = "string",
#'   Enabled = TRUE|FALSE,
#'   BatchSize = 123
#' )
#' ```
#'
#' @examples
#' # This operation updates a Lambda function event source mapping
#' \donttest{svc$update_event_source_mapping(
#'   BatchSize = 123L,
#'   Enabled = TRUE,
#'   FunctionName = "myFunction",
#'   UUID = "1234xCy789012"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_update_event_source_mapping
lambda_update_event_source_mapping <- function(UUID, FunctionName = NULL, Enabled = NULL, BatchSize = NULL) {
  op <- new_operation(
    name = "UpdateEventSourceMapping",
    http_method = "PUT",
    http_path = "/2015-03-31/event-source-mappings/{UUID}",
    paginator = list()
  )
  input <- .lambda$update_event_source_mapping_input(UUID = UUID, FunctionName = FunctionName, Enabled = Enabled, BatchSize = BatchSize)
  output <- .lambda$update_event_source_mapping_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$update_event_source_mapping <- lambda_update_event_source_mapping

#' Updates a Lambda function's code
#'
#' Updates a Lambda function\'s code.
#' 
#' The function\'s code is locked when you publish a version. You can\'t
#' modify the code of a published version, only the unpublished version.
#'
#' @usage
#' lambda_update_function_code(FunctionName, ZipFile, S3Bucket, S3Key,
#'   S3ObjectVersion, Publish, DryRun, RevisionId)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param ZipFile The base64-encoded contents of the deployment package. AWS SDK and AWS
#' CLI clients handle the encoding for you.
#' @param S3Bucket An Amazon S3 bucket in the same AWS Region as your function. The bucket
#' can be in a different AWS account.
#' @param S3Key The Amazon S3 key of the deployment package.
#' @param S3ObjectVersion For versioned objects, the version of the deployment package object to
#' use.
#' @param Publish Set to true to publish a new version of the function after updating the
#' code. This has the same effect as calling PublishVersion separately.
#' @param DryRun Set to true to validate the request parameters and access permissions
#' without modifying the function code.
#' @param RevisionId Only update the function if the revision ID matches the ID that\'s
#' specified. Use this option to avoid modifying a function that has
#' changed since you last read it.
#'
#' @section Request syntax:
#' ```
#' svc$update_function_code(
#'   FunctionName = "string",
#'   ZipFile = raw,
#'   S3Bucket = "string",
#'   S3Key = "string",
#'   S3ObjectVersion = "string",
#'   Publish = TRUE|FALSE,
#'   DryRun = TRUE|FALSE,
#'   RevisionId = "string"
#' )
#' ```
#'
#' @examples
#' # This operation updates a Lambda function's code
#' \donttest{svc$update_function_code(
#'   FunctionName = "myFunction",
#'   Publish = TRUE,
#'   S3Bucket = "myBucket",
#'   S3Key = "myKey",
#'   S3ObjectVersion = "1",
#'   ZipFile = "fileb://file-path/file.zip"
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_update_function_code
lambda_update_function_code <- function(FunctionName, ZipFile = NULL, S3Bucket = NULL, S3Key = NULL, S3ObjectVersion = NULL, Publish = NULL, DryRun = NULL, RevisionId = NULL) {
  op <- new_operation(
    name = "UpdateFunctionCode",
    http_method = "PUT",
    http_path = "/2015-03-31/functions/{FunctionName}/code",
    paginator = list()
  )
  input <- .lambda$update_function_code_input(FunctionName = FunctionName, ZipFile = ZipFile, S3Bucket = S3Bucket, S3Key = S3Key, S3ObjectVersion = S3ObjectVersion, Publish = Publish, DryRun = DryRun, RevisionId = RevisionId)
  output <- .lambda$update_function_code_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$update_function_code <- lambda_update_function_code

#' Modify the version-specific settings of a Lambda function
#'
#' Modify the version-specific settings of a Lambda function.
#' 
#' These settings can vary between versions of a function and are locked
#' when you publish a version. You can\'t modify the configuration of a
#' published version, only the unpublished version.
#' 
#' To configure function concurrency, use PutFunctionConcurrency. To grant
#' invoke permissions to an account or AWS service, use AddPermission.
#'
#' @usage
#' lambda_update_function_configuration(FunctionName, Role, Handler,
#'   Description, Timeout, MemorySize, VpcConfig, Environment, Runtime,
#'   DeadLetterConfig, KMSKeyArn, TracingConfig, RevisionId, Layers)
#'
#' @param FunctionName &#91;required&#93; The name of the Lambda function.
#' 
#' **Name formats**
#' 
#' -   **Function name** - `my-function`.
#' 
#' -   **Function ARN** -
#'     `arn:aws:lambda:us-west-2:123456789012:function:my-function`.
#' 
#' -   **Partial ARN** - `123456789012:function:my-function`.
#' 
#' The length constraint applies only to the full ARN. If you specify only
#' the function name, it is limited to 64 characters in length.
#' @param Role The Amazon Resource Name (ARN) of the function\'s execution role.
#' @param Handler The name of the method within your code that Lambda calls to execute
#' your function. The format includes the file name. It can also include
#' namespaces and other qualifiers, depending on the runtime. For more
#' information, see [Programming
#' Model](https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html).
#' @param Description A description of the function.
#' @param Timeout The amount of time that Lambda allows a function to run before stopping
#' it. The default is 3 seconds. The maximum allowed value is 900 seconds.
#' @param MemorySize The amount of memory that your function has access to. Increasing the
#' function\'s memory also increases its CPU allocation. The default value
#' is 128 MB. The value must be a multiple of 64 MB.
#' @param VpcConfig For network connectivity to AWS resources in a VPC, specify a list of
#' security groups and subnets in the VPC. When you connect a function to a
#' VPC, it can only access resources and the internet through that VPC. For
#' more information, see [VPC
#' Settings](https://docs.aws.amazon.com/lambda/latest/dg/vpc.html).
#' @param Environment Environment variables that are accessible from function code during
#' execution.
#' @param Runtime The identifier of the function\'s
#' [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html).
#' @param DeadLetterConfig A dead letter queue configuration that specifies the queue or topic
#' where Lambda sends asynchronous events when they fail processing. For
#' more information, see [Dead Letter
#' Queues](https://docs.aws.amazon.com/lambda/latest/dg/dlq.html).
#' @param KMSKeyArn The ARN of the AWS Key Management Service (AWS KMS) key that\'s used to
#' encrypt your function\'s environment variables. If it\'s not provided,
#' AWS Lambda uses a default service key.
#' @param TracingConfig Set `Mode` to `Active` to sample and trace a subset of incoming requests
#' with AWS X-Ray.
#' @param RevisionId Only update the function if the revision ID matches the ID that\'s
#' specified. Use this option to avoid modifying a function that has
#' changed since you last read it.
#' @param Layers A list of [function
#' layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
#' to add to the function\'s execution environment. Specify each layer by
#' its ARN, including the version.
#'
#' @section Request syntax:
#' ```
#' svc$update_function_configuration(
#'   FunctionName = "string",
#'   Role = "string",
#'   Handler = "string",
#'   Description = "string",
#'   Timeout = 123,
#'   MemorySize = 123,
#'   VpcConfig = list(
#'     SubnetIds = list(
#'       "string"
#'     ),
#'     SecurityGroupIds = list(
#'       "string"
#'     )
#'   ),
#'   Environment = list(
#'     Variables = list(
#'       "string"
#'     )
#'   ),
#'   Runtime = "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"java8"|"python2.7"|"python3.6"|"python3.7"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"provided",
#'   DeadLetterConfig = list(
#'     TargetArn = "string"
#'   ),
#'   KMSKeyArn = "string",
#'   TracingConfig = list(
#'     Mode = "Active"|"PassThrough"
#'   ),
#'   RevisionId = "string",
#'   Layers = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation updates a Lambda function's configuration
#' \donttest{svc$update_function_configuration(
#'   Description = "",
#'   FunctionName = "myFunction",
#'   Handler = "index.handler",
#'   MemorySize = 128L,
#'   Role = "arn:aws:iam::123456789012:role/lambda_basic_execution",
#'   Runtime = "python2.7",
#'   Timeout = 123L,
#'   VpcConfig = structure(
#'     list(),
#'     .Names = character(
#'       0
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname lambda_update_function_configuration
lambda_update_function_configuration <- function(FunctionName, Role = NULL, Handler = NULL, Description = NULL, Timeout = NULL, MemorySize = NULL, VpcConfig = NULL, Environment = NULL, Runtime = NULL, DeadLetterConfig = NULL, KMSKeyArn = NULL, TracingConfig = NULL, RevisionId = NULL, Layers = NULL) {
  op <- new_operation(
    name = "UpdateFunctionConfiguration",
    http_method = "PUT",
    http_path = "/2015-03-31/functions/{FunctionName}/configuration",
    paginator = list()
  )
  input <- .lambda$update_function_configuration_input(FunctionName = FunctionName, Role = Role, Handler = Handler, Description = Description, Timeout = Timeout, MemorySize = MemorySize, VpcConfig = VpcConfig, Environment = Environment, Runtime = Runtime, DeadLetterConfig = DeadLetterConfig, KMSKeyArn = KMSKeyArn, TracingConfig = TracingConfig, RevisionId = RevisionId, Layers = Layers)
  output <- .lambda$update_function_configuration_output()
  svc <- .lambda$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lambda$operations$update_function_configuration <- lambda_update_function_configuration
