# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' Amazon Elastic Kubernetes Service
#'
#' @description
#' Amazon Elastic Kubernetes Service (Amazon EKS) is a managed service that
#' makes it easy for you to run Kubernetes on AWS without needing to stand
#' up or maintain your own Kubernetes control plane. Kubernetes is an
#' open-source system for automating the deployment, scaling, and
#' management of containerized applications.
#' 
#' Amazon EKS runs up-to-date versions of the open-source Kubernetes
#' software, so you can use all the existing plugins and tooling from the
#' Kubernetes community. Applications running on Amazon EKS are fully
#' compatible with applications running on any standard Kubernetes
#' environment, whether running in on-premises data centers or public
#' clouds. This means that you can easily migrate any standard Kubernetes
#' application to Amazon EKS without any code modification required.
#'
#' @examples
#' # The following example creates an Amazon EKS cluster called prod.
#' \donttest{svc <- eks()
#' svc$create_cluster(
#'   version = "1.10",
#'   name = "prod",
#'   clientRequestToken = "1d2129a1-3d38-460a-9756-e5b91fddb951",
#'   resourcesVpcConfig = list(
#'     securityGroupIds = list(
#'       "sg-6979fe18"
#'     ),
#'     subnetIds = list(
#'       "subnet-6782e71e",
#'       "subnet-e7e761ac"
#'     )
#'   ),
#'   roleArn = "arn:aws:iam::012345678910:role/eks-service-role-AWSServiceRoleForAmazonEKS-J7ON..."
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=eks_create_cluster]{create_cluster} \tab Creates an Amazon EKS control plane \cr
#'  \link[=eks_delete_cluster]{delete_cluster} \tab Deletes the Amazon EKS cluster control plane \cr
#'  \link[=eks_describe_cluster]{describe_cluster} \tab Returns descriptive information about an Amazon EKS cluster \cr
#'  \link[=eks_describe_update]{describe_update} \tab Returns descriptive information about an update against your Amazon EKS cluster \cr
#'  \link[=eks_list_clusters]{list_clusters} \tab Lists the Amazon EKS clusters in your AWS account in the specified Region \cr
#'  \link[=eks_list_updates]{list_updates} \tab Lists the updates associated with an Amazon EKS cluster in your AWS account, in the specified Region\cr
#'  \link[=eks_update_cluster_config]{update_cluster_config} \tab Updates an Amazon EKS cluster configuration \cr
#'  \link[=eks_update_cluster_version]{update_cluster_version} \tab Updates an Amazon EKS cluster to the specified Kubernetes version 
#' }
#'
#' @rdname eks
#' @export
eks <- function() {
  .eks$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.eks <- list()

.eks$operations <- list()

.eks$metadata <- list(
  service_name = "eks",
  endpoints = list("*" = "eks.{region}.amazonaws.com", "cn-*" = "eks.{region}.amazonaws.com.cn"),
  service_id = "EKS",
  api_version = "2017-11-01",
  signing_name = "eks",
  json_version = "1.1",
  target_prefix = ""
)

.eks$handlers <- new_handlers("restjson", "v4")

.eks$service <- function() {
  new_service(.eks$metadata, .eks$handlers)
}
