% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_start_vpc_endpoint_service_private_dns_verification}
\alias{ec2_start_vpc_endpoint_service_private_dns_verification}
\title{Initiates the verification process to prove that the service provider
owns the private DNS name domain for the endpoint service}
\usage{
ec2_start_vpc_endpoint_service_private_dns_verification(DryRun,
  ServiceId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ServiceId}{[required] The ID of the endpoint service.}
}
\value{
A list with the following syntax:\preformatted{list(
  ReturnValue = TRUE|FALSE
)
}
}
\description{
Initiates the verification process to prove that the service provider
owns the private DNS name domain for the endpoint service.

The service provider must successfully perform the verification before
the consumer can use the name to access the service.

Before the service provider runs this command, they must add a record to
the DNS server. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/privatelink/endpoint-services-dns-validation.html#add-dns-txt-record}{Adding a TXT Record to Your Domain's DNS Server}
in the \emph{Amazon VPC User Guide}.
}
\section{Request syntax}{
\preformatted{svc$start_vpc_endpoint_service_private_dns_verification(
  DryRun = TRUE|FALSE,
  ServiceId = "string"
)
}
}

\keyword{internal}
