% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_certificate}
\alias{lightsail_create_certificate}
\title{Creates an SSL/TLS certificate for a Amazon Lightsail content delivery
network (CDN) distribution}
\usage{
lightsail_create_certificate(certificateName, domainName,
  subjectAlternativeNames, tags)
}
\arguments{
\item{certificateName}{[required] The name for the certificate.}

\item{domainName}{[required] The domain name (e.g., \code{example.com}) for the certificate.}

\item{subjectAlternativeNames}{An array of strings that specify the alternate domains (e.g.,
\code{example2.com}) and subdomains (e.g., \code{blog.example.com}) for the
certificate.

You can specify a maximum of nine alternate domains (in addition to the
primary domain name).

Wildcard domain entries (e.g., \verb{*.example.com}) are not supported.}

\item{tags}{The tag keys and optional values to add to the certificate during
create.

Use the \code{\link[=lightsail_tag_resource]{tag_resource}} action to tag a
resource after it's created.}
}
\value{
A list with the following syntax:\preformatted{list(
  certificate = list(
    certificateArn = "string",
    certificateName = "string",
    domainName = "string",
    certificateDetail = list(
      arn = "string",
      name = "string",
      domainName = "string",
      status = "PENDING_VALIDATION"|"ISSUED"|"INACTIVE"|"EXPIRED"|"VALIDATION_TIMED_OUT"|"REVOKED"|"FAILED",
      serialNumber = "string",
      subjectAlternativeNames = list(
        "string"
      ),
      domainValidationRecords = list(
        list(
          domainName = "string",
          resourceRecord = list(
            name = "string",
            type = "string",
            value = "string"
          )
        )
      ),
      requestFailureReason = "string",
      inUseResourceCount = 123,
      keyAlgorithm = "string",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      issuedAt = as.POSIXct(
        "2015-01-01"
      ),
      issuerCA = "string",
      notBefore = as.POSIXct(
        "2015-01-01"
      ),
      notAfter = as.POSIXct(
        "2015-01-01"
      ),
      eligibleToRenew = "string",
      renewalSummary = list(
        domainValidationRecords = list(
          list(
            domainName = "string",
            resourceRecord = list(
              name = "string",
              type = "string",
              value = "string"
            )
          )
        ),
        renewalStatus = "PendingAutoRenewal"|"PendingValidation"|"Success"|"Failed",
        renewalStatusReason = "string",
        updatedAt = as.POSIXct(
          "2015-01-01"
        )
      ),
      revokedAt = as.POSIXct(
        "2015-01-01"
      ),
      revocationReason = "string",
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      ),
      supportCode = "string"
    ),
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    )
  ),
  operations = list(
    list(
      id = "string",
      resourceName = "string",
      resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      location = list(
        availabilityZone = "string",
        regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
      ),
      isTerminal = TRUE|FALSE,
      operationDetails = "string",
      operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
      status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
      statusChangedAt = as.POSIXct(
        "2015-01-01"
      ),
      errorCode = "string",
      errorDetails = "string"
    )
  )
)
}
}
\description{
Creates an SSL/TLS certificate for a Amazon Lightsail content delivery
network (CDN) distribution.

After the certificate is created, use the
\code{\link[=lightsail_attach_certificate_to_distribution]{attach_certificate_to_distribution}}
action to attach the certificate to your distribution.

Only certificates created in the \code{us-east-1} AWS Region can be attached
to Lightsail distributions. Lightsail distributions are global resources
that can reference an origin in any AWS Region, and distribute its
content globally. However, all distributions are located in the
\code{us-east-1} Region.
}
\section{Request syntax}{
\preformatted{svc$create_certificate(
  certificateName = "string",
  domainName = "string",
  subjectAlternativeNames = list(
    "string"
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
