% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_describe_fargate_profile}
\alias{eks_describe_fargate_profile}
\title{Returns descriptive information about an AWS Fargate profile}
\usage{
eks_describe_fargate_profile(clusterName, fargateProfileName)
}
\arguments{
\item{clusterName}{[required] The name of the Amazon EKS cluster associated with the Fargate profile.}

\item{fargateProfileName}{[required] The name of the Fargate profile to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  fargateProfile = list(
    fargateProfileName = "string",
    fargateProfileArn = "string",
    clusterName = "string",
    createdAt = as.POSIXct(
      "2015-01-01"
    ),
    podExecutionRoleArn = "string",
    subnets = list(
      "string"
    ),
    selectors = list(
      list(
        namespace = "string",
        labels = list(
          "string"
        )
      )
    ),
    status = "CREATING"|"ACTIVE"|"DELETING"|"CREATE_FAILED"|"DELETE_FAILED",
    tags = list(
      "string"
    )
  )
)
}
}
\description{
Returns descriptive information about an AWS Fargate profile.
}
\section{Request syntax}{
\preformatted{svc$describe_fargate_profile(
  clusterName = "string",
  fargateProfileName = "string"
)
}
}

\keyword{internal}
