% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_detach_internet_gateway}
\alias{ec2_detach_internet_gateway}
\title{Detaches an internet gateway from a VPC, disabling connectivity between
the internet and the VPC}
\usage{
ec2_detach_internet_gateway(DryRun, InternetGatewayId, VpcId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InternetGatewayId}{[required] The ID of the internet gateway.}

\item{VpcId}{[required] The ID of the VPC.}
}
\value{
An empty list.
}
\description{
Detaches an internet gateway from a VPC, disabling connectivity between
the internet and the VPC. The VPC must not contain any running instances
with Elastic IP addresses or public IPv4 addresses.
}
\section{Request syntax}{
\preformatted{svc$detach_internet_gateway(
  DryRun = TRUE|FALSE,
  InternetGatewayId = "string",
  VpcId = "string"
)
}
}

\examples{
\dontrun{
# This example detaches the specified Internet gateway from the specified
# VPC.
svc$detach_internet_gateway(
  InternetGatewayId = "igw-c0a643a9",
  VpcId = "vpc-a01106c2"
)
}

}
\keyword{internal}
