% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_transit_gateway_peering_attachment}
\alias{ec2_create_transit_gateway_peering_attachment}
\title{Requests a transit gateway peering attachment between the specified
transit gateway (requester) and a peer transit gateway (accepter)}
\usage{
ec2_create_transit_gateway_peering_attachment(TransitGatewayId,
  PeerTransitGatewayId, PeerAccountId, PeerRegion, TagSpecifications,
  DryRun)
}
\arguments{
\item{TransitGatewayId}{[required] The ID of the transit gateway.}

\item{PeerTransitGatewayId}{[required] The ID of the peer transit gateway with which to create the peering
attachment.}

\item{PeerAccountId}{[required] The AWS account ID of the owner of the peer transit gateway.}

\item{PeerRegion}{[required] The Region where the peer transit gateway is located.}

\item{TagSpecifications}{The tags to apply to the transit gateway peering attachment.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  TransitGatewayPeeringAttachment = list(
    TransitGatewayAttachmentId = "string",
    RequesterTgwInfo = list(
      TransitGatewayId = "string",
      OwnerId = "string",
      Region = "string"
    ),
    AccepterTgwInfo = list(
      TransitGatewayId = "string",
      OwnerId = "string",
      Region = "string"
    ),
    Status = list(
      Code = "string",
      Message = "string"
    ),
    State = "initiating"|"initiatingRequest"|"pendingAcceptance"|"rollingBack"|"pending"|"available"|"modifying"|"deleting"|"deleted"|"failed"|"rejected"|"rejecting"|"failing",
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}
\description{
Requests a transit gateway peering attachment between the specified
transit gateway (requester) and a peer transit gateway (accepter). The
transit gateways must be in different Regions. The peer transit gateway
can be in your account or a different AWS account.

After you create the peering attachment, the owner of the accepter
transit gateway must accept the attachment request.
}
\section{Request syntax}{
\preformatted{svc$create_transit_gateway_peering_attachment(
  TransitGatewayId = "string",
  PeerTransitGatewayId = "string",
  PeerAccountId = "string",
  PeerRegion = "string",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
