% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_vpc_tenancy}
\alias{ec2_modify_vpc_tenancy}
\title{Modifies the instance tenancy attribute of the specified VPC}
\usage{
ec2_modify_vpc_tenancy(VpcId, InstanceTenancy, DryRun)
}
\arguments{
\item{VpcId}{[required] The ID of the VPC.}

\item{InstanceTenancy}{[required] The instance tenancy attribute for the VPC.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ReturnValue = TRUE|FALSE
)
}
}
\description{
Modifies the instance tenancy attribute of the specified VPC. You can
change the instance tenancy attribute of a VPC to \code{default} only. You
cannot change the instance tenancy attribute to \code{dedicated}.

After you modify the tenancy of the VPC, any new instances that you
launch into the VPC have a tenancy of \code{default}, unless you specify
otherwise during launch. The tenancy of any existing instances in the
VPC is not affected.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html}{Dedicated Instances}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$modify_vpc_tenancy(
  VpcId = "string",
  InstanceTenancy = "default",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
