% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_conversion_tasks}
\alias{ec2_describe_conversion_tasks}
\title{Describes the specified conversion tasks or all your conversion tasks}
\usage{
ec2_describe_conversion_tasks(ConversionTaskIds, DryRun)
}
\arguments{
\item{ConversionTaskIds}{The conversion task IDs.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ConversionTasks = list(
    list(
      ConversionTaskId = "string",
      ExpirationTime = "string",
      ImportInstance = list(
        Description = "string",
        InstanceId = "string",
        Platform = "Windows",
        Volumes = list(
          list(
            AvailabilityZone = "string",
            BytesConverted = 123,
            Description = "string",
            Image = list(
              Checksum = "string",
              Format = "VMDK"|"RAW"|"VHD",
              ImportManifestUrl = "string",
              Size = 123
            ),
            Status = "string",
            StatusMessage = "string",
            Volume = list(
              Id = "string",
              Size = 123
            )
          )
        )
      ),
      ImportVolume = list(
        AvailabilityZone = "string",
        BytesConverted = 123,
        Description = "string",
        Image = list(
          Checksum = "string",
          Format = "VMDK"|"RAW"|"VHD",
          ImportManifestUrl = "string",
          Size = 123
        ),
        Volume = list(
          Id = "string",
          Size = 123
        )
      ),
      State = "active"|"cancelling"|"cancelled"|"completed",
      StatusMessage = "string",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}
\description{
Describes the specified conversion tasks or all your conversion tasks.
For more information, see the \href{https://docs.aws.amazon.com/vm-import/latest/userguide/}{VM Import/Export User Guide}.

For information about the import manifest referenced by this API action,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html}{VM Import Manifest}.
}
\section{Request syntax}{
\preformatted{svc$describe_conversion_tasks(
  ConversionTaskIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
