% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_untag_resource}
\alias{batch_untag_resource}
\title{Deletes specified tags from an AWS Batch resource}
\usage{
batch_untag_resource(resourceArn, tagKeys)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the resource from which to delete
tags. AWS Batch resources that support tags are compute environments,
jobs, job definitions, and job queues. ARNs for child jobs of array and
multi-node parallel (MNP) jobs are not supported.}

\item{tagKeys}{[required] The keys of the tags to be removed.}
}
\value{
An empty list.
}
\description{
Deletes specified tags from an AWS Batch resource.
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  resourceArn = "string",
  tagKeys = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This demonstrates calling the UntagResource action.
svc$untag_resource(
  resourceArn = "arn:aws:batch:us-east-1:123456789012:job-definition/sleep30:1",
  tagKeys = list(
    "Stage"
  )
)
}

}
\keyword{internal}
