% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_certificate}
\alias{lightsail_create_certificate}
\title{Creates an SSL/TLS certificate for a Amazon Lightsail content delivery
network (CDN) distribution}
\usage{
lightsail_create_certificate(certificateName, domainName,
  subjectAlternativeNames, tags)
}
\arguments{
\item{certificateName}{[required] The name for the certificate.}

\item{domainName}{[required] The domain name (e.g., \code{example.com}) for the certificate.}

\item{subjectAlternativeNames}{An array of strings that specify the alternate domains (e.g.,
\code{example2.com}) and subdomains (e.g., \code{blog.example.com}) for the
certificate.

You can specify a maximum of nine alternate domains (in addition to the
primary domain name).

Wildcard domain entries (e.g., \verb{*.example.com}) are not supported.}

\item{tags}{The tag keys and optional values to add to the certificate during
create.

Use the \code{TagResource} action to tag a resource after it's created.}
}
\description{
Creates an SSL/TLS certificate for a Amazon Lightsail content delivery
network (CDN) distribution.

After the certificate is created, use the
\code{AttachCertificateToDistribution} action to attach the certificate to
your distribution.

Only certificates created in the \code{us-east-1} AWS Region can be attached
to Lightsail distributions. Lightsail distributions are global resources
that can reference an origin in any AWS Region, and distribute its
content globally. However, all distributions are located in the
\code{us-east-1} Region.
}
\section{Request syntax}{
\preformatted{svc$create_certificate(
  certificateName = "string",
  domainName = "string",
  subjectAlternativeNames = list(
    "string"
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
