% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_list_addons}
\alias{eks_list_addons}
\title{Lists the available add-ons}
\usage{
eks_list_addons(clusterName, maxResults, nextToken)
}
\arguments{
\item{clusterName}{[required] The name of the cluster.}

\item{maxResults}{The maximum number of add-on results returned by \code{ListAddonsRequest} in
paginated output. When you use this parameter, \code{ListAddonsRequest}
returns only \code{maxResults} results in a single page along with a
\code{nextToken} response element. You can see the remaining results of the
initial request by sending another \code{ListAddonsRequest} request with the
returned \code{nextToken} value. This value can be between 1 and 100. If you
don't use this parameter, \code{ListAddonsRequest} returns up to 100 results
and a \code{nextToken} value, if applicable.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{ListAddonsRequest} where \code{maxResults} was used and the results exceeded
the value of that parameter. Pagination continues from the end of the
previous results that returned the \code{nextToken} value.

This token should be treated as an opaque identifier that is used only
to retrieve the next items in a list and not for other programmatic
purposes.}
}
\description{
Lists the available add-ons.
}
\section{Request syntax}{
\preformatted{svc$list_addons(
  clusterName = "string",
  maxResults = 123,
  nextToken = "string"
)
}
}

\keyword{internal}
