% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_fleet_instances}
\alias{ec2_describe_fleet_instances}
\title{Describes the running instances for the specified EC2 Fleet}
\usage{
ec2_describe_fleet_instances(DryRun, MaxResults, NextToken, FleetId,
  Filters)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{MaxResults}{The maximum number of results to return in a single call. Specify a
value between 1 and 1000. The default value is 1000. To retrieve the
remaining results, make another call with the returned \code{NextToken}
value.}

\item{NextToken}{The token for the next set of results.}

\item{FleetId}{[required] The ID of the EC2 Fleet.}

\item{Filters}{The filters.
\itemize{
\item \code{instance-type} - The instance type.
}}
}
\description{
Describes the running instances for the specified EC2 Fleet.
}
\section{Request syntax}{
\preformatted{svc$describe_fleet_instances(
  DryRun = TRUE|FALSE,
  MaxResults = 123,
  NextToken = "string",
  FleetId = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
