% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_transit_gateway_connect_peer}
\alias{ec2_create_transit_gateway_connect_peer}
\title{Creates a Connect peer for a specified transit gateway Connect
attachment between a transit gateway and an appliance}
\usage{
ec2_create_transit_gateway_connect_peer(TransitGatewayAttachmentId,
  TransitGatewayAddress, PeerAddress, BgpOptions, InsideCidrBlocks,
  TagSpecifications, DryRun)
}
\arguments{
\item{TransitGatewayAttachmentId}{[required] The ID of the Connect attachment.}

\item{TransitGatewayAddress}{The peer IP address (GRE outer IP address) on the transit gateway side
of the Connect peer, which must be specified from a transit gateway CIDR
block. If not specified, Amazon automatically assigns the first
available IP address from the transit gateway CIDR block.}

\item{PeerAddress}{[required] The peer IP address (GRE outer IP address) on the appliance side of the
Connect peer.}

\item{BgpOptions}{The BGP options for the Connect peer.}

\item{InsideCidrBlocks}{[required] The range of inside IP addresses that are used for BGP peering. You must
specify a size /29 IPv4 CIDR block from the \verb{169.254.0.0/16} range. The
first address from the range must be configured on the appliance as the
BGP IP address. You can also optionally specify a size /125 IPv6 CIDR
block from the \verb{fd00::/8} range.}

\item{TagSpecifications}{The tags to apply to the Connect peer.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a Connect peer for a specified transit gateway Connect
attachment between a transit gateway and an appliance.

The peer address and transit gateway address must be the same IP address
family (IPv4 or IPv6).

For more information, see \href{https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer}{Connect peers}
in the \emph{Transit Gateways Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_transit_gateway_connect_peer(
  TransitGatewayAttachmentId = "string",
  TransitGatewayAddress = "string",
  PeerAddress = "string",
  BgpOptions = list(
    PeerAsn = 123
  ),
  InsideCidrBlocks = list(
    "string"
  ),
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
