% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_allocate_hosts}
\alias{ec2_allocate_hosts}
\title{Allocates a Dedicated Host to your account}
\usage{
ec2_allocate_hosts(AutoPlacement, AvailabilityZone, ClientToken,
  InstanceType, InstanceFamily, Quantity, TagSpecifications, HostRecovery)
}
\arguments{
\item{AutoPlacement}{Indicates whether the host accepts any untargeted instance launches that
match its instance type configuration, or if it only accepts Host
tenancy instance launches that specify its unique host ID. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding}{Understanding Instance Placement and Host Affinity}
in the \emph{Amazon EC2 User Guide for Linux Instances}.

Default: \code{on}}

\item{AvailabilityZone}{[required] The Availability Zone in which to allocate the Dedicated Host.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.}

\item{InstanceType}{Specifies the instance type to be supported by the Dedicated Hosts. If
you specify an instance type, the Dedicated Hosts support instances of
the specified instance type only.

If you want the Dedicated Hosts to support multiple instance types in a
specific instance family, omit this parameter and specify
\strong{InstanceFamily} instead. You cannot specify \strong{InstanceType} and
\strong{InstanceFamily} in the same request.}

\item{InstanceFamily}{Specifies the instance family to be supported by the Dedicated Hosts. If
you specify an instance family, the Dedicated Hosts support multiple
instance types within that instance family.

If you want the Dedicated Hosts to support a specific instance type
only, omit this parameter and specify \strong{InstanceType} instead. You
cannot specify \strong{InstanceFamily} and \strong{InstanceType} in the same
request.}

\item{Quantity}{[required] The number of Dedicated Hosts to allocate to your account with these
parameters.}

\item{TagSpecifications}{The tags to apply to the Dedicated Host during creation.}

\item{HostRecovery}{Indicates whether to enable or disable host recovery for the Dedicated
Host. Host recovery is disabled by default. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html}{Host Recovery}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

Default: \code{off}}
}
\description{
Allocates a Dedicated Host to your account. At a minimum, specify the
supported instance type or instance family, the Availability Zone in
which to allocate the host, and the number of hosts to allocate.
}
\section{Request syntax}{
\preformatted{svc$allocate_hosts(
  AutoPlacement = "on"|"off",
  AvailabilityZone = "string",
  ClientToken = "string",
  InstanceType = "string",
  InstanceFamily = "string",
  Quantity = 123,
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  HostRecovery = "on"|"off"
)
}
}

\keyword{internal}
