% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_tag_resource}
\alias{batch_tag_resource}
\title{Associates the specified tags to a resource with the specified
resourceArn}
\usage{
batch_tag_resource(resourceArn, tags)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the resource that tags are added to.
AWS Batch resources that support tags are compute environments, jobs,
job definitions, and job queues. ARNs for child jobs of array and
multi-node parallel (MNP) jobs are not supported.}

\item{tags}{[required] The tags that you apply to the resource to help you categorize and
organize your resources. Each tag consists of a key and an optional
value. For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html}{Tagging AWS Resources}
in \emph{AWS General Reference}.}
}
\description{
Associates the specified tags to a resource with the specified
\code{resourceArn}. If existing tags on a resource aren't specified in the
request parameters, they aren't changed. When a resource is deleted, the
tags associated with that resource are deleted as well. AWS Batch
resources that support tags are compute environments, jobs, job
definitions, and job queues. ARNs for child jobs of array and multi-node
parallel (MNP) jobs are not supported.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  resourceArn = "string",
  tags = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This demonstrates calling the TagResource action.
svc$tag_resource(
  resourceArn = "arn:aws:batch:us-east-1:123456789012:job-definition/sleep30:1",
  tags = list(
    Stage = "Alpha"
  )
)
}

}
\keyword{internal}
