% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_purchase_host_reservation}
\alias{ec2_purchase_host_reservation}
\title{Purchase a reservation with configurations that match those of your
Dedicated Host}
\usage{
ec2_purchase_host_reservation(ClientToken, CurrencyCode, HostIdSet,
  LimitPrice, OfferingId)
}
\arguments{
\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure idempotency of
the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html}{How to Ensure Idempotency}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{CurrencyCode}{The currency in which the \code{totalUpfrontPrice}, \code{LimitPrice}, and
\code{totalHourlyPrice} amounts are specified. At this time, the only
supported currency is \code{USD}.}

\item{HostIdSet}{[required] The IDs of the Dedicated Hosts with which the reservation will be
associated.}

\item{LimitPrice}{The specified limit is checked against the total upfront cost of the
reservation (calculated as the offering's upfront cost multiplied by
the host count). If the total upfront cost is greater than the specified
price limit, the request fails. This is used to ensure that the purchase
does not exceed the expected upfront cost of the purchase. At this time,
the only supported currency is \code{USD}. For example, to indicate a limit
price of USD 100, specify 100.00.}

\item{OfferingId}{[required] The ID of the offering.}
}
\description{
Purchase a reservation with configurations that match those of your
Dedicated Host. You must have active Dedicated Hosts in your account
before you purchase a reservation. This action results in the specified
reservation being purchased and charged to your account.
}
\section{Request syntax}{
\preformatted{svc$purchase_host_reservation(
  ClientToken = "string",
  CurrencyCode = "USD",
  HostIdSet = list(
    "string"
  ),
  LimitPrice = "string",
  OfferingId = "string"
)
}
}

\keyword{internal}
