% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_import_key_pair}
\alias{ec2_import_key_pair}
\title{Imports the public key from an RSA key pair that you created with a
third-party tool}
\usage{
ec2_import_key_pair(DryRun, KeyName, PublicKeyMaterial)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{KeyName}{[required] A unique name for the key pair.}

\item{PublicKeyMaterial}{[required] The public key. For API calls, the text must be base64-encoded. For
command line tools, base64 encoding is performed for you.}
}
\description{
Imports the public key from an RSA key pair that you created with a
third-party tool. Compare this with CreateKeyPair, in which AWS creates
the key pair and gives the keys to you (AWS keeps a copy of the public
key). With ImportKeyPair, you create the key pair and give AWS just the
public key. The private key is never transferred between you and AWS.
}
\details{
For more information about key pairs, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html}{Key Pairs}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$import_key_pair(
  DryRun = TRUE|FALSE,
  KeyName = "string",
  PublicKeyMaterial = raw
)
}
}

\keyword{internal}
