% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_bundle_tasks}
\alias{ec2_describe_bundle_tasks}
\title{Describes one or more of your bundling tasks}
\usage{
ec2_describe_bundle_tasks(BundleIds, Filters, DryRun)
}
\arguments{
\item{BundleIds}{One or more bundle task IDs.

Default: Describes all your bundle tasks.}

\item{Filters}{One or more filters.
\itemize{
\item \code{bundle-id} - The ID of the bundle task.
\item \code{error-code} - If the task failed, the error code returned.
\item \code{error-message} - If the task failed, the error message returned.
\item \code{instance-id} - The ID of the instance.
\item \code{progress} - The level of task completion, as a percentage (for
example, 20\%).
\item \code{s3-bucket} - The Amazon S3 bucket to store the AMI.
\item \code{s3-prefix} - The beginning of the AMI name.
\item \code{start-time} - The time the task started (for example,
2013-09-15T17:15:20.000Z).
\item \code{state} - The state of the task (\code{pending} \| \code{waiting-for-shutdown}
\| \code{bundling} \| \code{storing} \| \code{cancelling} \| \code{complete} \|
\code{failed}).
\item \code{update-time} - The time of the most recent update for the task.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes one or more of your bundling tasks.
}
\details{
Completed bundle tasks are listed for only a limited time. If your
bundle task is no longer in the list, you can still register an AMI from
it. Just use \code{RegisterImage} with the Amazon S3 bucket name and image
manifest name you provided to the bundle task.
}
\section{Request syntax}{
\preformatted{svc$describe_bundle_tasks(
  BundleIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
