% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_get_workflow_execution_history}
\alias{swf_get_workflow_execution_history}
\title{Returns the history of the specified workflow execution}
\usage{
swf_get_workflow_execution_history(domain, execution, nextPageToken,
  maximumPageSize, reverseOrder)
}
\arguments{
\item{domain}{[required] The name of the domain containing the workflow execution.}

\item{execution}{[required] Specifies the workflow execution for which to return the history.}

\item{nextPageToken}{If \code{NextPageToken} is returned there are more results available. The
value of \code{NextPageToken} is a unique pagination token for each page.
Make the call again using the returned token to retrieve the next page.
Keep all other arguments unchanged. Each pagination token expires after
60 seconds. Using an expired pagination token will return a \code{400} error:
"\code{Specified token has exceeded its maximum lifetime}".

The configured \code{maximumPageSize} determines how many results can be
returned in a single call.}

\item{maximumPageSize}{The maximum number of results that are returned per call. Use
\code{nextPageToken} to obtain further pages of results.}

\item{reverseOrder}{When set to \code{true}, returns the events in reverse order. By default the
results are returned in ascending order of the \code{eventTimeStamp} of the
events.}
}
\description{
Returns the history of the specified workflow execution. The results may
be split into multiple pages. To retrieve subsequent pages, make the
call again using the \code{nextPageToken} returned by the initial call.
}
\details{
This operation is eventually consistent. The results are best effort and
may not exactly reflect recent updates and changes.

\strong{Access Control}

You can use IAM policies to control this action's access to Amazon SWF
resources as follows:
\itemize{
\item Use a \code{Resource} element with the domain name to limit the action to
only specified domains.
\item Use an \code{Action} element to allow or deny permission to call this
action.
\item You cannot use an IAM policy to constrain this action's parameters.
}

If the caller doesn't have sufficient permissions to invoke the action,
or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's \code{cause} parameter is set
to \code{OPERATION_NOT_PERMITTED}. For details and example IAM policies, see
\href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html}{Using IAM to Manage Access to Amazon SWF Workflows}
in the \emph{Amazon SWF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_workflow_execution_history(
  domain = "string",
  execution = list(
    workflowId = "string",
    runId = "string"
  ),
  nextPageToken = "string",
  maximumPageSize = 123,
  reverseOrder = TRUE|FALSE
)
}
}

\keyword{internal}
