# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' AmazonMQ
#'
#' @description
#' Amazon MQ is a managed message broker service for Apache ActiveMQ that makes it easy to set up and operate message brokers in the cloud. A message broker allows software applications and components to communicate using various programming languages, operating systems, and formal messaging protocols.
#'
#' @examples
#' \donttest{svc <- mq()
#' svc$create_broker(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=mq_create_broker]{create_broker} \tab Creates a broker \cr
#'  \link[=mq_create_configuration]{create_configuration} \tab Creates a new configuration for the specified configuration name \cr
#'  \link[=mq_create_tags]{create_tags} \tab Add a tag to a resource \cr
#'  \link[=mq_create_user]{create_user} \tab Creates an ActiveMQ user \cr
#'  \link[=mq_delete_broker]{delete_broker} \tab Deletes a broker \cr
#'  \link[=mq_delete_tags]{delete_tags} \tab Removes a tag from a resource \cr
#'  \link[=mq_delete_user]{delete_user} \tab Deletes an ActiveMQ user \cr
#'  \link[=mq_describe_broker]{describe_broker} \tab Returns information about the specified broker \cr
#'  \link[=mq_describe_broker_engine_types]{describe_broker_engine_types} \tab Describe available engine types and versions \cr
#'  \link[=mq_describe_broker_instance_options]{describe_broker_instance_options} \tab Describe available broker instance options \cr
#'  \link[=mq_describe_configuration]{describe_configuration} \tab Returns information about the specified configuration \cr
#'  \link[=mq_describe_configuration_revision]{describe_configuration_revision} \tab Returns the specified configuration revision for the specified configuration\cr
#'  \link[=mq_describe_user]{describe_user} \tab Returns information about an ActiveMQ user \cr
#'  \link[=mq_list_brokers]{list_brokers} \tab Returns a list of all brokers \cr
#'  \link[=mq_list_configuration_revisions]{list_configuration_revisions} \tab Returns a list of all revisions for the specified configuration \cr
#'  \link[=mq_list_configurations]{list_configurations} \tab Returns a list of all configurations \cr
#'  \link[=mq_list_tags]{list_tags} \tab Lists tags for a resource \cr
#'  \link[=mq_list_users]{list_users} \tab Returns a list of all ActiveMQ users \cr
#'  \link[=mq_reboot_broker]{reboot_broker} \tab Reboots a broker \cr
#'  \link[=mq_update_broker]{update_broker} \tab Adds a pending configuration change to a broker \cr
#'  \link[=mq_update_configuration]{update_configuration} \tab Updates the specified configuration \cr
#'  \link[=mq_update_user]{update_user} \tab Updates the information for an ActiveMQ user 
#' }
#'
#' @rdname mq
#' @export
mq <- function() {
  .mq$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.mq <- list()

.mq$operations <- list()

.mq$metadata <- list(
  service_name = "mq",
  endpoints = list("*" = list(endpoint = "mq.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "mq.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "mq",
  api_version = "2017-11-27",
  signing_name = "mq",
  json_version = "1.1",
  target_prefix = ""
)

.mq$handlers <- new_handlers("restjson", "v4")

.mq$service <- function() {
  new_service(.mq$metadata, .mq$handlers)
}
