% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_poll_for_activity_task}
\alias{swf_poll_for_activity_task}
\title{Used by workers to get an ActivityTask from the specified activity
taskList}
\usage{
swf_poll_for_activity_task(domain, taskList, identity)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the task lists being polled.}

\item{taskList}{[required] Specifies the task list to poll for activity tasks.

The specified string must not start or end with whitespace. It must not
contain a \code{:} (colon), \code{/} (slash), \code{|} (vertical bar), or any control
characters (\verb{\\u0000-\\u001f} | \verb{\\u007f-\\u009f}). Also, it must not \emph{be}
the literal string \code{arn}.}

\item{identity}{Identity of the worker making the request, recorded in the
\code{ActivityTaskStarted} event in the workflow history. This enables
diagnostic tracing when problems arise. The form of this identity is
user defined.}
}
\value{
A list with the following syntax:\preformatted{list(
  taskToken = "string",
  activityId = "string",
  startedEventId = 123,
  workflowExecution = list(
    workflowId = "string",
    runId = "string"
  ),
  activityType = list(
    name = "string",
    version = "string"
  ),
  input = "string"
)
}
}
\description{
Used by workers to get an ActivityTask from the specified activity
\code{taskList}. This initiates a long poll, where the service holds the HTTP
connection open and responds as soon as a task becomes available. The
maximum time the service holds on to the request before responding is 60
seconds. If no task is available within 60 seconds, the poll returns an
empty result. An empty result, in this context, means that an
ActivityTask is returned, but that the value of taskToken is an empty
string. If a task is returned, the worker should use its type to
identify and process it correctly.

Workers should set their client side socket timeout to at least 70
seconds (10 seconds higher than the maximum time service may hold the
poll request).

\strong{Access Control}

You can use IAM policies to control this action's access to Amazon SWF
resources as follows:
\itemize{
\item Use a \code{Resource} element with the domain name to limit the action to
only specified domains.
\item Use an \code{Action} element to allow or deny permission to call this
action.
\item Constrain the \code{taskList.name} parameter by using a \code{Condition}
element with the \code{swf:taskList.name} key to allow the action to
access only certain task lists.
}

If the caller doesn't have sufficient permissions to invoke the action,
or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's \code{cause} parameter is set
to \code{OPERATION_NOT_PERMITTED}. For details and example IAM policies, see
\href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html}{Using IAM to Manage Access to Amazon SWF Workflows}
in the \emph{Amazon SWF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$poll_for_activity_task(
  domain = "string",
  taskList = list(
    name = "string"
  ),
  identity = "string"
)
}
}

\keyword{internal}
