% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivs_operations.R
\name{ivs_update_playback_restriction_policy}
\alias{ivs_update_playback_restriction_policy}
\title{Updates a specified playback restriction policy}
\usage{
ivs_update_playback_restriction_policy(
  allowedCountries = NULL,
  allowedOrigins = NULL,
  arn,
  enableStrictOriginEnforcement = NULL,
  name = NULL
)
}
\arguments{
\item{allowedCountries}{A list of country codes that control geoblocking restriction. Allowed
values are the officially assigned \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 3166-1 alpha-2} codes.
Default: All countries (an empty array).}

\item{allowedOrigins}{A list of origin sites that control CORS restriction. Allowed values are
the same as valid values of the Origin header defined at
\url{https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin}.
Default: All origins (an empty array).}

\item{arn}{[required] ARN of the playback-restriction-policy to be updated.}

\item{enableStrictOriginEnforcement}{Whether channel playback is constrained by origin site. Default:
\code{false}.}

\item{name}{Playback-restriction-policy name. The value does not need to be unique.}
}
\description{
Updates a specified playback restriction policy.

See \url{https://www.paws-r-sdk.com/docs/ivs_update_playback_restriction_policy/} for full documentation.
}
\keyword{internal}
