% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_get_query_runtime_statistics}
\alias{athena_get_query_runtime_statistics}
\title{Returns query execution runtime statistics related to a single execution
of a query if you have access to the workgroup in which the query ran}
\usage{
athena_get_query_runtime_statistics(QueryExecutionId)
}
\arguments{
\item{QueryExecutionId}{[required] The unique ID of the query execution.}
}
\description{
Returns query execution runtime statistics related to a single execution of a query if you have access to the workgroup in which the query ran. Statistics from the \code{Timeline} section of the response object are available as soon as QueryExecutionStatus$State is in a SUCCEEDED or FAILED state. The remaining non-timeline statistics in the response (like stage-level input and output row count and data size) are updated asynchronously and may not be available immediately after a query completes. The non-timeline statistics are also not included when a query has row-level filters defined in Lake Formation.

See \url{https://www.paws-r-sdk.com/docs/athena_get_query_runtime_statistics/} for full documentation.
}
\keyword{internal}
