% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_put_resource_policy}
\alias{kinesis_put_resource_policy}
\title{Attaches a resource-based policy to a data stream or registered consumer}
\usage{
kinesis_put_resource_policy(ResourceARN, Policy)
}
\arguments{
\item{ResourceARN}{[required] The Amazon Resource Name (ARN) of the data stream or consumer.}

\item{Policy}{[required] Details of the resource policy. It must include the identity of the
principal and the actions allowed on this resource. This is formatted as
a JSON string.}
}
\description{
Attaches a resource-based policy to a data stream or registered consumer. If you are using an identity other than the root user of the Amazon Web Services account that owns the resource, the calling identity must have the \code{\link[=kinesis_put_resource_policy]{put_resource_policy}} permissions on the specified Kinesis Data Streams resource and belong to the owner's account in order to use this operation. If you don't have \code{\link[=kinesis_put_resource_policy]{put_resource_policy}} permissions, Amazon Kinesis Data Streams returns a \verb{403 Access Denied error}. If you receive a \code{ResourceNotFoundException}, check to see if you passed a valid stream or consumer resource.

See \url{https://www.paws-r-sdk.com/docs/kinesis_put_resource_policy/} for full documentation.
}
\keyword{internal}
