% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_list_sessions}
\alias{athena_list_sessions}
\title{Lists the sessions in a workgroup that are in an active state like
CREATING, CREATED, IDLE, or BUSY}
\usage{
athena_list_sessions(
  WorkGroup,
  StateFilter = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{WorkGroup}{[required] The workgroup to which the session belongs.}

\item{StateFilter}{A filter for a specific session state. A description of each state
follows.

\code{CREATING} - The session is being started, including acquiring
resources.

\code{CREATED} - The session has been started.

\code{IDLE} - The session is able to accept a calculation.

\code{BUSY} - The session is processing another task and is unable to accept
a calculation.

\code{TERMINATING} - The session is in the process of shutting down.

\code{TERMINATED} - The session and its resources are no longer running.

\code{DEGRADED} - The session has no healthy coordinators.

\code{FAILED} - Due to a failure, the session and its resources are no longer
running.}

\item{MaxResults}{The maximum number of sessions to return.}

\item{NextToken}{A token generated by the Athena service that specifies where to continue
pagination if a previous request was truncated. To obtain the next set
of pages, pass in the \code{NextToken} from the response object of the
previous page call.}
}
\description{
Lists the sessions in a workgroup that are in an active state like \code{CREATING}, \code{CREATED}, \code{IDLE}, or \code{BUSY}. Newer sessions are listed first; older sessions are listed later.

See \url{https://www.paws-r-sdk.com/docs/athena_list_sessions/} for full documentation.
}
\keyword{internal}
