% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_update_dev_endpoint}
\alias{glue_update_dev_endpoint}
\title{Updates a specified development endpoint}
\usage{
glue_update_dev_endpoint(
  EndpointName,
  PublicKey = NULL,
  AddPublicKeys = NULL,
  DeletePublicKeys = NULL,
  CustomLibraries = NULL,
  UpdateEtlLibraries = NULL,
  DeleteArguments = NULL,
  AddArguments = NULL
)
}
\arguments{
\item{EndpointName}{[required] The name of the \code{DevEndpoint} to be updated.}

\item{PublicKey}{The public key for the \code{DevEndpoint} to use.}

\item{AddPublicKeys}{The list of public keys for the \code{DevEndpoint} to use.}

\item{DeletePublicKeys}{The list of public keys to be deleted from the \code{DevEndpoint}.}

\item{CustomLibraries}{Custom Python or Java libraries to be loaded in the \code{DevEndpoint}.}

\item{UpdateEtlLibraries}{\code{True} if the list of custom libraries to be loaded in the development
endpoint needs to be updated, or \code{False} if otherwise.}

\item{DeleteArguments}{The list of argument keys to be deleted from the map of arguments used
to configure the \code{DevEndpoint}.}

\item{AddArguments}{The map of arguments to add the map of arguments used to configure the
\code{DevEndpoint}.

Valid arguments are:
\itemize{
\item \code{"--enable-glue-datacatalog": ""}
}

You can specify a version of Python support for development endpoints by
using the \code{Arguments} parameter in the
\code{\link[=glue_create_dev_endpoint]{create_dev_endpoint}} or
\code{\link[=glue_update_dev_endpoint]{update_dev_endpoint}} APIs. If no arguments
are provided, the version defaults to Python 2.}
}
\description{
Updates a specified development endpoint.

See \url{https://www.paws-r-sdk.com/docs/glue_update_dev_endpoint/} for full documentation.
}
\keyword{internal}
