% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_create_delivery_stream}
\alias{firehose_create_delivery_stream}
\title{Creates a Kinesis Data Firehose delivery stream}
\usage{
firehose_create_delivery_stream(
  DeliveryStreamName,
  DeliveryStreamType = NULL,
  KinesisStreamSourceConfiguration = NULL,
  DeliveryStreamEncryptionConfigurationInput = NULL,
  S3DestinationConfiguration = NULL,
  ExtendedS3DestinationConfiguration = NULL,
  RedshiftDestinationConfiguration = NULL,
  ElasticsearchDestinationConfiguration = NULL,
  AmazonopensearchserviceDestinationConfiguration = NULL,
  SplunkDestinationConfiguration = NULL,
  HttpEndpointDestinationConfiguration = NULL,
  Tags = NULL
)
}
\arguments{
\item{DeliveryStreamName}{[required] The name of the delivery stream. This name must be unique per AWS
account in the same AWS Region. If the delivery streams are in different
accounts or different Regions, you can have multiple delivery streams
with the same name.}

\item{DeliveryStreamType}{The delivery stream type. This parameter can be one of the following
values:
\itemize{
\item \code{DirectPut}: Provider applications access the delivery stream
directly.
\item \code{KinesisStreamAsSource}: The delivery stream uses a Kinesis data
stream as a source.
}}

\item{KinesisStreamSourceConfiguration}{When a Kinesis data stream is used as the source for the delivery
stream, a KinesisStreamSourceConfiguration containing the Kinesis data
stream Amazon Resource Name (ARN) and the role ARN for the source
stream.}

\item{DeliveryStreamEncryptionConfigurationInput}{Used to specify the type and Amazon Resource Name (ARN) of the KMS key
needed for Server-Side Encryption (SSE).}

\item{S3DestinationConfiguration}{[Deprecated] The destination in Amazon S3. You can specify only one
destination.}

\item{ExtendedS3DestinationConfiguration}{The destination in Amazon S3. You can specify only one destination.}

\item{RedshiftDestinationConfiguration}{The destination in Amazon Redshift. You can specify only one
destination.}

\item{ElasticsearchDestinationConfiguration}{The destination in Amazon ES. You can specify only one destination.}

\item{AmazonopensearchserviceDestinationConfiguration}{}

\item{SplunkDestinationConfiguration}{The destination in Splunk. You can specify only one destination.}

\item{HttpEndpointDestinationConfiguration}{Enables configuring Kinesis Firehose to deliver data to any HTTP
endpoint destination. You can specify only one destination.}

\item{Tags}{A set of tags to assign to the delivery stream. A tag is a key-value
pair that you can define and assign to AWS resources. Tags are metadata.
For example, you can add friendly names and descriptions or other types
of information that can help you distinguish the delivery stream. For
more information about tags, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html}{Using Cost Allocation Tags}
in the AWS Billing and Cost Management User Guide.

You can specify up to 50 tags when creating a delivery stream.}
}
\description{
Creates a Kinesis Data Firehose delivery stream.

See \url{https://paws-r.github.io/docs/firehose/create_delivery_stream.html} for full documentation.
}
\keyword{internal}
