% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearch_operations.R
\name{cloudsearch_define_index_field}
\alias{cloudsearch_define_index_field}
\title{Configures an IndexField for the search domain}
\usage{
cloudsearch_define_index_field(DomainName, IndexField)
}
\arguments{
\item{DomainName}{[required]}

\item{IndexField}{[required] The index field and field options you want to configure.}
}
\description{
Configures an \code{IndexField} for the search domain. Used to create new fields and modify existing ones. You must specify the name of the domain you are configuring and an index field configuration. The index field configuration specifies a unique name, the index field type, and the options you want to configure for the field. The options you can specify depend on the \code{IndexFieldType}. If the field exists, the new configuration replaces the old one. For more information, see <a href="https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html" target="_blank">Configuring Index Fields</a> in the \emph{Amazon CloudSearch Developer Guide}.

See \url{https://paws-r.github.io/docs/cloudsearch/define_index_field.html} for full documentation.
}
\keyword{internal}
