# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include kinesis_service.R
NULL

#' Adds or updates tags for the specified Kinesis data stream
#'
#' Adds or updates tags for the specified Kinesis data stream. Each time
#' you invoke this operation, you can specify up to 10 tags. If you want to
#' add more than 10 tags to your stream, you can invoke this operation
#' multiple times. In total, each stream can have up to 50 tags.
#' 
#' If tags have already been assigned to the stream, `AddTagsToStream`
#' overwrites any existing tags that correspond to the specified tag keys.
#' 
#' AddTagsToStream has a limit of five transactions per second per account.
#'
#' @usage
#' kinesis_add_tags_to_stream(StreamName, Tags)
#'
#' @param StreamName &#91;required&#93; The name of the stream.
#' @param Tags &#91;required&#93; A set of up to 10 key-value pairs to use to create the tags.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags_to_stream(
#'   StreamName = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_add_tags_to_stream
kinesis_add_tags_to_stream <- function(StreamName, Tags) {
  op <- new_operation(
    name = "AddTagsToStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$add_tags_to_stream_input(StreamName = StreamName, Tags = Tags)
  output <- .kinesis$add_tags_to_stream_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$add_tags_to_stream <- kinesis_add_tags_to_stream

#' Creates a Kinesis data stream
#'
#' Creates a Kinesis data stream. A stream captures and transports data
#' records that are continuously emitted from different data sources or
#' *producers*. Scale-out within a stream is explicitly supported by means
#' of shards, which are uniquely identified groups of data records in a
#' stream.
#' 
#' You specify and control the number of shards that a stream is composed
#' of. Each shard can support reads up to five transactions per second, up
#' to a maximum data read total of 2 MB per second. Each shard can support
#' writes up to 1,000 records per second, up to a maximum data write total
#' of 1 MB per second. If the amount of data input increases or decreases,
#' you can add or remove shards.
#' 
#' The stream name identifies the stream. The name is scoped to the AWS
#' account used by the application. It is also scoped by AWS Region. That
#' is, two streams in two different accounts can have the same name, and
#' two streams in the same account, but in two different Regions, can have
#' the same name.
#' 
#' `CreateStream` is an asynchronous operation. Upon receiving a
#' `CreateStream` request, Kinesis Data Streams immediately returns and
#' sets the stream status to `CREATING`. After the stream is created,
#' Kinesis Data Streams sets the stream status to `ACTIVE`. You should
#' perform read and write operations only on an `ACTIVE` stream.
#' 
#' You receive a `LimitExceededException` when making a `CreateStream`
#' request when you try to do one of the following:
#' 
#' -   Have more than five streams in the `CREATING` state at any point in
#'     time.
#' 
#' -   Create more shards than are authorized for your account.
#' 
#' For the default shard limit for an AWS account, see [Amazon Kinesis Data
#' Streams
#' Limits](http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
#' in the *Amazon Kinesis Data Streams Developer Guide*. To increase this
#' limit, [contact AWS
#' Support](http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html).
#' 
#' You can use `DescribeStream` to check the stream status, which is
#' returned in `StreamStatus`.
#' 
#' CreateStream has a limit of five transactions per second per account.
#'
#' @usage
#' kinesis_create_stream(StreamName, ShardCount)
#'
#' @param StreamName &#91;required&#93; A name to identify the stream. The stream name is scoped to the AWS
#' account used by the application that creates the stream. It is also
#' scoped by AWS Region. That is, two streams in two different AWS accounts
#' can have the same name. Two streams in the same AWS account but in two
#' different Regions can also have the same name.
#' @param ShardCount &#91;required&#93; The number of shards that the stream will use. The throughput of the
#' stream is a function of the number of shards; more shards are required
#' for greater provisioned throughput.
#' 
#' DefaultShardLimit;
#'
#' @section Request syntax:
#' ```
#' svc$create_stream(
#'   StreamName = "string",
#'   ShardCount = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_create_stream
kinesis_create_stream <- function(StreamName, ShardCount) {
  op <- new_operation(
    name = "CreateStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$create_stream_input(StreamName = StreamName, ShardCount = ShardCount)
  output <- .kinesis$create_stream_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$create_stream <- kinesis_create_stream

#' Decreases the Kinesis data stream's retention period, which is the
#' length of time data records are accessible after they are added to the
#' stream
#'
#' Decreases the Kinesis data stream\'s retention period, which is the
#' length of time data records are accessible after they are added to the
#' stream. The minimum value of a stream\'s retention period is 24 hours.
#' 
#' This operation may result in lost data. For example, if the stream\'s
#' retention period is 48 hours and is decreased to 24 hours, any data
#' already in the stream that is older than 24 hours is inaccessible.
#'
#' @usage
#' kinesis_decrease_stream_retention_period(StreamName,
#'   RetentionPeriodHours)
#'
#' @param StreamName &#91;required&#93; The name of the stream to modify.
#' @param RetentionPeriodHours &#91;required&#93; The new retention period of the stream, in hours. Must be less than the
#' current retention period.
#'
#' @section Request syntax:
#' ```
#' svc$decrease_stream_retention_period(
#'   StreamName = "string",
#'   RetentionPeriodHours = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_decrease_stream_retention_period
kinesis_decrease_stream_retention_period <- function(StreamName, RetentionPeriodHours) {
  op <- new_operation(
    name = "DecreaseStreamRetentionPeriod",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$decrease_stream_retention_period_input(StreamName = StreamName, RetentionPeriodHours = RetentionPeriodHours)
  output <- .kinesis$decrease_stream_retention_period_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$decrease_stream_retention_period <- kinesis_decrease_stream_retention_period

#' Deletes a Kinesis data stream and all its shards and data
#'
#' Deletes a Kinesis data stream and all its shards and data. You must shut
#' down any applications that are operating on the stream before you delete
#' the stream. If an application attempts to operate on a deleted stream,
#' it receives the exception `ResourceNotFoundException`.
#' 
#' If the stream is in the `ACTIVE` state, you can delete it. After a
#' `DeleteStream` request, the specified stream is in the `DELETING` state
#' until Kinesis Data Streams completes the deletion.
#' 
#' **Note:** Kinesis Data Streams might continue to accept data read and
#' write operations, such as PutRecord, PutRecords, and GetRecords, on a
#' stream in the `DELETING` state until the stream deletion is complete.
#' 
#' When you delete a stream, any shards in that stream are also deleted,
#' and any tags are dissociated from the stream.
#' 
#' You can use the DescribeStream operation to check the state of the
#' stream, which is returned in `StreamStatus`.
#' 
#' DeleteStream has a limit of five transactions per second per account.
#'
#' @usage
#' kinesis_delete_stream(StreamName, EnforceConsumerDeletion)
#'
#' @param StreamName &#91;required&#93; The name of the stream to delete.
#' @param EnforceConsumerDeletion If this parameter is unset (`null`) or if you set it to `false`, and the
#' stream has registered consumers, the call to `DeleteStream` fails with a
#' `ResourceInUseException`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_stream(
#'   StreamName = "string",
#'   EnforceConsumerDeletion = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_delete_stream
kinesis_delete_stream <- function(StreamName, EnforceConsumerDeletion = NULL) {
  op <- new_operation(
    name = "DeleteStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$delete_stream_input(StreamName = StreamName, EnforceConsumerDeletion = EnforceConsumerDeletion)
  output <- .kinesis$delete_stream_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$delete_stream <- kinesis_delete_stream

#' To deregister a consumer, provide its ARN
#'
#' To deregister a consumer, provide its ARN. Alternatively, you can
#' provide the ARN of the data stream and the name you gave the consumer
#' when you registered it. You may also provide all three parameters, as
#' long as they don\'t conflict with each other. If you don\'t know the
#' name or ARN of the consumer that you want to deregister, you can use the
#' ListStreamConsumers operation to get a list of the descriptions of all
#' the consumers that are currently registered with a given data stream.
#' The description of a consumer contains its name and ARN.
#' 
#' This operation has a limit of five transactions per second per account.
#'
#' @usage
#' kinesis_deregister_stream_consumer(StreamARN, ConsumerName, ConsumerARN)
#'
#' @param StreamARN The ARN of the Kinesis data stream that the consumer is registered with.
#' For more information, see [Amazon Resource Names (ARNs) and AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
#' @param ConsumerName The name that you gave to the consumer.
#' @param ConsumerARN The ARN returned by Kinesis Data Streams when you registered the
#' consumer. If you don\'t know the ARN of the consumer that you want to
#' deregister, you can use the ListStreamConsumers operation to get a list
#' of the descriptions of all the consumers that are currently registered
#' with a given data stream. The description of a consumer contains its
#' ARN.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_stream_consumer(
#'   StreamARN = "string",
#'   ConsumerName = "string",
#'   ConsumerARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_deregister_stream_consumer
kinesis_deregister_stream_consumer <- function(StreamARN = NULL, ConsumerName = NULL, ConsumerARN = NULL) {
  op <- new_operation(
    name = "DeregisterStreamConsumer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$deregister_stream_consumer_input(StreamARN = StreamARN, ConsumerName = ConsumerName, ConsumerARN = ConsumerARN)
  output <- .kinesis$deregister_stream_consumer_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$deregister_stream_consumer <- kinesis_deregister_stream_consumer

#' Describes the shard limits and usage for the account
#'
#' Describes the shard limits and usage for the account.
#' 
#' If you update your account limits, the old limits might be returned for
#' a few minutes.
#' 
#' This operation has a limit of one transaction per second per account.
#'
#' @usage
#' kinesis_describe_limits()
#'
#' @section Request syntax:
#' ```
#' svc$describe_limits()
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_describe_limits
kinesis_describe_limits <- function() {
  op <- new_operation(
    name = "DescribeLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$describe_limits_input()
  output <- .kinesis$describe_limits_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$describe_limits <- kinesis_describe_limits

#' Describes the specified Kinesis data stream
#'
#' Describes the specified Kinesis data stream.
#' 
#' The information returned includes the stream name, Amazon Resource Name
#' (ARN), creation time, enhanced metric configuration, and shard map. The
#' shard map is an array of shard objects. For each shard object, there is
#' the hash key and sequence number ranges that the shard spans, and the
#' IDs of any earlier shards that played in a role in creating the shard.
#' Every record ingested in the stream is identified by a sequence number,
#' which is assigned when the record is put into the stream.
#' 
#' You can limit the number of shards returned by each call. For more
#' information, see [Retrieving Shards from a
#' Stream](http://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-retrieve-shards.html)
#' in the *Amazon Kinesis Data Streams Developer Guide*.
#' 
#' There are no guarantees about the chronological order shards returned.
#' To process shards in chronological order, use the ID of the parent shard
#' to track the lineage to the oldest shard.
#' 
#' This operation has a limit of 10 transactions per second per account.
#'
#' @usage
#' kinesis_describe_stream(StreamName, Limit, ExclusiveStartShardId)
#'
#' @param StreamName &#91;required&#93; The name of the stream to describe.
#' @param Limit The maximum number of shards to return in a single call. The default
#' value is 100. If you specify a value greater than 100, at most 100
#' shards are returned.
#' @param ExclusiveStartShardId The shard ID of the shard to start with.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stream(
#'   StreamName = "string",
#'   Limit = 123,
#'   ExclusiveStartShardId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_describe_stream
kinesis_describe_stream <- function(StreamName, Limit = NULL, ExclusiveStartShardId = NULL) {
  op <- new_operation(
    name = "DescribeStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$describe_stream_input(StreamName = StreamName, Limit = Limit, ExclusiveStartShardId = ExclusiveStartShardId)
  output <- .kinesis$describe_stream_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$describe_stream <- kinesis_describe_stream

#' To get the description of a registered consumer, provide the ARN of the
#' consumer
#'
#' To get the description of a registered consumer, provide the ARN of the
#' consumer. Alternatively, you can provide the ARN of the data stream and
#' the name you gave the consumer when you registered it. You may also
#' provide all three parameters, as long as they don\'t conflict with each
#' other. If you don\'t know the name or ARN of the consumer that you want
#' to describe, you can use the ListStreamConsumers operation to get a list
#' of the descriptions of all the consumers that are currently registered
#' with a given data stream.
#' 
#' This operation has a limit of 20 transactions per second per account.
#'
#' @usage
#' kinesis_describe_stream_consumer(StreamARN, ConsumerName, ConsumerARN)
#'
#' @param StreamARN The ARN of the Kinesis data stream that the consumer is registered with.
#' For more information, see [Amazon Resource Names (ARNs) and AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
#' @param ConsumerName The name that you gave to the consumer.
#' @param ConsumerARN The ARN returned by Kinesis Data Streams when you registered the
#' consumer.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stream_consumer(
#'   StreamARN = "string",
#'   ConsumerName = "string",
#'   ConsumerARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_describe_stream_consumer
kinesis_describe_stream_consumer <- function(StreamARN = NULL, ConsumerName = NULL, ConsumerARN = NULL) {
  op <- new_operation(
    name = "DescribeStreamConsumer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$describe_stream_consumer_input(StreamARN = StreamARN, ConsumerName = ConsumerName, ConsumerARN = ConsumerARN)
  output <- .kinesis$describe_stream_consumer_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$describe_stream_consumer <- kinesis_describe_stream_consumer

#' Provides a summarized description of the specified Kinesis data stream
#' without the shard list
#'
#' Provides a summarized description of the specified Kinesis data stream
#' without the shard list.
#' 
#' The information returned includes the stream name, Amazon Resource Name
#' (ARN), status, record retention period, approximate creation time,
#' monitoring, encryption details, and open shard count.
#'
#' @usage
#' kinesis_describe_stream_summary(StreamName)
#'
#' @param StreamName &#91;required&#93; The name of the stream to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stream_summary(
#'   StreamName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_describe_stream_summary
kinesis_describe_stream_summary <- function(StreamName) {
  op <- new_operation(
    name = "DescribeStreamSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$describe_stream_summary_input(StreamName = StreamName)
  output <- .kinesis$describe_stream_summary_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$describe_stream_summary <- kinesis_describe_stream_summary

#' Disables enhanced monitoring
#'
#' Disables enhanced monitoring.
#'
#' @usage
#' kinesis_disable_enhanced_monitoring(StreamName, ShardLevelMetrics)
#'
#' @param StreamName &#91;required&#93; The name of the Kinesis data stream for which to disable enhanced
#' monitoring.
#' @param ShardLevelMetrics &#91;required&#93; List of shard-level metrics to disable.
#' 
#' The following are the valid shard-level metrics. The value \"`ALL`\"
#' disables every metric.
#' 
#' -   `IncomingBytes`
#' 
#' -   `IncomingRecords`
#' 
#' -   `OutgoingBytes`
#' 
#' -   `OutgoingRecords`
#' 
#' -   `WriteProvisionedThroughputExceeded`
#' 
#' -   `ReadProvisionedThroughputExceeded`
#' 
#' -   `IteratorAgeMilliseconds`
#' 
#' -   `ALL`
#' 
#' For more information, see [Monitoring the Amazon Kinesis Data Streams
#' Service with Amazon
#' CloudWatch](http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html)
#' in the *Amazon Kinesis Data Streams Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$disable_enhanced_monitoring(
#'   StreamName = "string",
#'   ShardLevelMetrics = list(
#'     "IncomingBytes"|"IncomingRecords"|"OutgoingBytes"|"OutgoingRecords"|"WriteProvisionedThroughputExceeded"|"ReadProvisionedThroughputExceeded"|"IteratorAgeMilliseconds"|"ALL"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_disable_enhanced_monitoring
kinesis_disable_enhanced_monitoring <- function(StreamName, ShardLevelMetrics) {
  op <- new_operation(
    name = "DisableEnhancedMonitoring",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$disable_enhanced_monitoring_input(StreamName = StreamName, ShardLevelMetrics = ShardLevelMetrics)
  output <- .kinesis$disable_enhanced_monitoring_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$disable_enhanced_monitoring <- kinesis_disable_enhanced_monitoring

#' Enables enhanced Kinesis data stream monitoring for shard-level metrics
#'
#' Enables enhanced Kinesis data stream monitoring for shard-level metrics.
#'
#' @usage
#' kinesis_enable_enhanced_monitoring(StreamName, ShardLevelMetrics)
#'
#' @param StreamName &#91;required&#93; The name of the stream for which to enable enhanced monitoring.
#' @param ShardLevelMetrics &#91;required&#93; List of shard-level metrics to enable.
#' 
#' The following are the valid shard-level metrics. The value \"`ALL`\"
#' enables every metric.
#' 
#' -   `IncomingBytes`
#' 
#' -   `IncomingRecords`
#' 
#' -   `OutgoingBytes`
#' 
#' -   `OutgoingRecords`
#' 
#' -   `WriteProvisionedThroughputExceeded`
#' 
#' -   `ReadProvisionedThroughputExceeded`
#' 
#' -   `IteratorAgeMilliseconds`
#' 
#' -   `ALL`
#' 
#' For more information, see [Monitoring the Amazon Kinesis Data Streams
#' Service with Amazon
#' CloudWatch](http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html)
#' in the *Amazon Kinesis Data Streams Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$enable_enhanced_monitoring(
#'   StreamName = "string",
#'   ShardLevelMetrics = list(
#'     "IncomingBytes"|"IncomingRecords"|"OutgoingBytes"|"OutgoingRecords"|"WriteProvisionedThroughputExceeded"|"ReadProvisionedThroughputExceeded"|"IteratorAgeMilliseconds"|"ALL"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_enable_enhanced_monitoring
kinesis_enable_enhanced_monitoring <- function(StreamName, ShardLevelMetrics) {
  op <- new_operation(
    name = "EnableEnhancedMonitoring",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$enable_enhanced_monitoring_input(StreamName = StreamName, ShardLevelMetrics = ShardLevelMetrics)
  output <- .kinesis$enable_enhanced_monitoring_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$enable_enhanced_monitoring <- kinesis_enable_enhanced_monitoring

#' Gets data records from a Kinesis data stream's shard
#'
#' Gets data records from a Kinesis data stream\'s shard.
#' 
#' Specify a shard iterator using the `ShardIterator` parameter. The shard
#' iterator specifies the position in the shard from which you want to
#' start reading data records sequentially. If there are no records
#' available in the portion of the shard that the iterator points to,
#' GetRecords returns an empty list. It might take multiple calls to get to
#' a portion of the shard that contains records.
#' 
#' You can scale by provisioning multiple shards per stream while
#' considering service limits (for more information, see [Amazon Kinesis
#' Data Streams
#' Limits](http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
#' in the *Amazon Kinesis Data Streams Developer Guide*). Your application
#' should have one thread per shard, each reading continuously from its
#' stream. To read from a stream continually, call GetRecords in a loop.
#' Use GetShardIterator to get the shard iterator to specify in the first
#' GetRecords call. GetRecords returns a new shard iterator in
#' `NextShardIterator`. Specify the shard iterator returned in
#' `NextShardIterator` in subsequent calls to GetRecords. If the shard has
#' been closed, the shard iterator can\'t return more data and GetRecords
#' returns `null` in `NextShardIterator`. You can terminate the loop when
#' the shard is closed, or when the shard iterator reaches the record with
#' the sequence number or other attribute that marks it as the last record
#' to process.
#' 
#' Each data record can be up to 1 MiB in size, and each shard can read up
#' to 2 MiB per second. You can ensure that your calls don\'t exceed the
#' maximum supported size or throughput by using the `Limit` parameter to
#' specify the maximum number of records that GetRecords can return.
#' Consider your average record size when determining this limit. The
#' maximum number of records that can be returned per call is 10,000.
#' 
#' The size of the data returned by GetRecords varies depending on the
#' utilization of the shard. The maximum size of data that GetRecords can
#' return is 10 MiB. If a call returns this amount of data, subsequent
#' calls made within the next 5 seconds throw
#' `ProvisionedThroughputExceededException`. If there is insufficient
#' provisioned throughput on the stream, subsequent calls made within the
#' next 1 second throw `ProvisionedThroughputExceededException`. GetRecords
#' doesn\'t return any data when it throws an exception. For this reason,
#' we recommend that you wait 1 second between calls to GetRecords.
#' However, it\'s possible that the application will get exceptions for
#' longer than 1 second.
#' 
#' To detect whether the application is falling behind in processing, you
#' can use the `MillisBehindLatest` response attribute. You can also
#' monitor the stream using CloudWatch metrics and other mechanisms (see
#' [Monitoring](http://docs.aws.amazon.com/kinesis/latest/dev/monitoring.html)
#' in the *Amazon Kinesis Data Streams Developer Guide*).
#' 
#' Each Amazon Kinesis record includes a value,
#' `ApproximateArrivalTimestamp`, that is set when a stream successfully
#' receives and stores a record. This is commonly referred to as a
#' server-side time stamp, whereas a client-side time stamp is set when a
#' data producer creates or sends the record to a stream (a data producer
#' is any data source putting data records into a stream, for example with
#' PutRecords). The time stamp has millisecond precision. There are no
#' guarantees about the time stamp accuracy, or that the time stamp is
#' always increasing. For example, records in a shard or across a stream
#' might have time stamps that are out of order.
#' 
#' This operation has a limit of five transactions per second per account.
#'
#' @usage
#' kinesis_get_records(ShardIterator, Limit)
#'
#' @param ShardIterator &#91;required&#93; The position in the shard from which you want to start sequentially
#' reading data records. A shard iterator specifies this position using the
#' sequence number of a data record in the shard.
#' @param Limit The maximum number of records to return. Specify a value of up to
#' 10,000. If you specify a value that is greater than 10,000, GetRecords
#' throws `InvalidArgumentException`.
#'
#' @section Request syntax:
#' ```
#' svc$get_records(
#'   ShardIterator = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_get_records
kinesis_get_records <- function(ShardIterator, Limit = NULL) {
  op <- new_operation(
    name = "GetRecords",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$get_records_input(ShardIterator = ShardIterator, Limit = Limit)
  output <- .kinesis$get_records_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$get_records <- kinesis_get_records

#' Gets an Amazon Kinesis shard iterator
#'
#' Gets an Amazon Kinesis shard iterator. A shard iterator expires 5
#' minutes after it is returned to the requester.
#' 
#' A shard iterator specifies the shard position from which to start
#' reading data records sequentially. The position is specified using the
#' sequence number of a data record in a shard. A sequence number is the
#' identifier associated with every record ingested in the stream, and is
#' assigned when a record is put into the stream. Each stream has one or
#' more shards.
#' 
#' You must specify the shard iterator type. For example, you can set the
#' `ShardIteratorType` parameter to read exactly from the position denoted
#' by a specific sequence number by using the `AT_SEQUENCE_NUMBER` shard
#' iterator type. Alternatively, the parameter can read right after the
#' sequence number by using the `AFTER_SEQUENCE_NUMBER` shard iterator
#' type, using sequence numbers returned by earlier calls to PutRecord,
#' PutRecords, GetRecords, or DescribeStream. In the request, you can
#' specify the shard iterator type `AT_TIMESTAMP` to read records from an
#' arbitrary point in time, `TRIM_HORIZON` to cause `ShardIterator` to
#' point to the last untrimmed record in the shard in the system (the
#' oldest data record in the shard), or `LATEST` so that you always read
#' the most recent data in the shard.
#' 
#' When you read repeatedly from a stream, use a GetShardIterator request
#' to get the first shard iterator for use in your first GetRecords request
#' and for subsequent reads use the shard iterator returned by the
#' GetRecords request in `NextShardIterator`. A new shard iterator is
#' returned by every GetRecords request in `NextShardIterator`, which you
#' use in the `ShardIterator` parameter of the next GetRecords request.
#' 
#' If a GetShardIterator request is made too often, you receive a
#' `ProvisionedThroughputExceededException`. For more information about
#' throughput limits, see GetRecords, and [Streams
#' Limits](http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
#' in the *Amazon Kinesis Data Streams Developer Guide*.
#' 
#' If the shard is closed, GetShardIterator returns a valid iterator for
#' the last sequence number of the shard. A shard can be closed as a result
#' of using SplitShard or MergeShards.
#' 
#' GetShardIterator has a limit of five transactions per second per account
#' per open shard.
#'
#' @usage
#' kinesis_get_shard_iterator(StreamName, ShardId, ShardIteratorType,
#'   StartingSequenceNumber, Timestamp)
#'
#' @param StreamName &#91;required&#93; The name of the Amazon Kinesis data stream.
#' @param ShardId &#91;required&#93; The shard ID of the Kinesis Data Streams shard to get the iterator for.
#' @param ShardIteratorType &#91;required&#93; Determines how the shard iterator is used to start reading data records
#' from the shard.
#' 
#' The following are the valid Amazon Kinesis shard iterator types:
#' 
#' -   AT\\_SEQUENCE\\_NUMBER - Start reading from the position denoted by a
#'     specific sequence number, provided in the value
#'     `StartingSequenceNumber`.
#' 
#' -   AFTER\\_SEQUENCE\\_NUMBER - Start reading right after the position
#'     denoted by a specific sequence number, provided in the value
#'     `StartingSequenceNumber`.
#' 
#' -   AT\\_TIMESTAMP - Start reading from the position denoted by a
#'     specific time stamp, provided in the value `Timestamp`.
#' 
#' -   TRIM\\_HORIZON - Start reading at the last untrimmed record in the
#'     shard in the system, which is the oldest data record in the shard.
#' 
#' -   LATEST - Start reading just after the most recent record in the
#'     shard, so that you always read the most recent data in the shard.
#' @param StartingSequenceNumber The sequence number of the data record in the shard from which to start
#' reading. Used with shard iterator type AT\\_SEQUENCE\\_NUMBER and
#' AFTER\\_SEQUENCE\\_NUMBER.
#' @param Timestamp The time stamp of the data record from which to start reading. Used with
#' shard iterator type AT\\_TIMESTAMP. A time stamp is the Unix epoch date
#' with precision in milliseconds. For example,
#' `2016-04-04T19:58:46.480-00:00` or `1459799926.480`. If a record with
#' this exact time stamp does not exist, the iterator returned is for the
#' next (later) record. If the time stamp is older than the current trim
#' horizon, the iterator returned is for the oldest untrimmed data record
#' (TRIM\\_HORIZON).
#'
#' @section Request syntax:
#' ```
#' svc$get_shard_iterator(
#'   StreamName = "string",
#'   ShardId = "string",
#'   ShardIteratorType = "AT_SEQUENCE_NUMBER"|"AFTER_SEQUENCE_NUMBER"|"TRIM_HORIZON"|"LATEST"|"AT_TIMESTAMP",
#'   StartingSequenceNumber = "string",
#'   Timestamp = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_get_shard_iterator
kinesis_get_shard_iterator <- function(StreamName, ShardId, ShardIteratorType, StartingSequenceNumber = NULL, Timestamp = NULL) {
  op <- new_operation(
    name = "GetShardIterator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$get_shard_iterator_input(StreamName = StreamName, ShardId = ShardId, ShardIteratorType = ShardIteratorType, StartingSequenceNumber = StartingSequenceNumber, Timestamp = Timestamp)
  output <- .kinesis$get_shard_iterator_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$get_shard_iterator <- kinesis_get_shard_iterator

#' Increases the Kinesis data stream's retention period, which is the
#' length of time data records are accessible after they are added to the
#' stream
#'
#' Increases the Kinesis data stream\'s retention period, which is the
#' length of time data records are accessible after they are added to the
#' stream. The maximum value of a stream\'s retention period is 168 hours
#' (7 days).
#' 
#' If you choose a longer stream retention period, this operation increases
#' the time period during which records that have not yet expired are
#' accessible. However, it does not make previous, expired data (older than
#' the stream\'s previous retention period) accessible after the operation
#' has been called. For example, if a stream\'s retention period is set to
#' 24 hours and is increased to 168 hours, any data that is older than 24
#' hours remains inaccessible to consumer applications.
#'
#' @usage
#' kinesis_increase_stream_retention_period(StreamName,
#'   RetentionPeriodHours)
#'
#' @param StreamName &#91;required&#93; The name of the stream to modify.
#' @param RetentionPeriodHours &#91;required&#93; The new retention period of the stream, in hours. Must be more than the
#' current retention period.
#'
#' @section Request syntax:
#' ```
#' svc$increase_stream_retention_period(
#'   StreamName = "string",
#'   RetentionPeriodHours = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_increase_stream_retention_period
kinesis_increase_stream_retention_period <- function(StreamName, RetentionPeriodHours) {
  op <- new_operation(
    name = "IncreaseStreamRetentionPeriod",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$increase_stream_retention_period_input(StreamName = StreamName, RetentionPeriodHours = RetentionPeriodHours)
  output <- .kinesis$increase_stream_retention_period_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$increase_stream_retention_period <- kinesis_increase_stream_retention_period

#' Lists the shards in a stream and provides information about each shard
#'
#' Lists the shards in a stream and provides information about each shard.
#' This operation has a limit of 100 transactions per second per data
#' stream.
#' 
#' This API is a new operation that is used by the Amazon Kinesis Client
#' Library (KCL). If you have a fine-grained IAM policy that only allows
#' specific operations, you must update your policy to allow calls to this
#' API. For more information, see [Controlling Access to Amazon Kinesis
#' Data Streams Resources Using
#' IAM](https://docs.aws.amazon.com/streams/latest/dev/controlling-access.html).
#'
#' @usage
#' kinesis_list_shards(StreamName, NextToken, ExclusiveStartShardId,
#'   MaxResults, StreamCreationTimestamp)
#'
#' @param StreamName The name of the data stream whose shards you want to list.
#' 
#' You cannot specify this parameter if you specify the `NextToken`
#' parameter.
#' @param NextToken When the number of shards in the data stream is greater than the default
#' value for the `MaxResults` parameter, or if you explicitly specify a
#' value for `MaxResults` that is less than the number of shards in the
#' data stream, the response includes a pagination token named `NextToken`.
#' You can specify this `NextToken` value in a subsequent call to
#' `ListShards` to list the next set of shards.
#' 
#' Don\'t specify `StreamName` or `StreamCreationTimestamp` if you specify
#' `NextToken` because the latter unambiguously identifies the stream.
#' 
#' You can optionally specify a value for the `MaxResults` parameter when
#' you specify `NextToken`. If you specify a `MaxResults` value that is
#' less than the number of shards that the operation returns if you don\'t
#' specify `MaxResults`, the response will contain a new `NextToken` value.
#' You can use the new `NextToken` value in a subsequent call to the
#' `ListShards` operation.
#' 
#' Tokens expire after 300 seconds. When you obtain a value for `NextToken`
#' in the response to a call to `ListShards`, you have 300 seconds to use
#' that value. If you specify an expired token in a call to `ListShards`,
#' you get `ExpiredNextTokenException`.
#' @param ExclusiveStartShardId Specify this parameter to indicate that you want to list the shards
#' starting with the shard whose ID immediately follows
#' `ExclusiveStartShardId`.
#' 
#' If you don\'t specify this parameter, the default behavior is for
#' `ListShards` to list the shards starting with the first one in the
#' stream.
#' 
#' You cannot specify this parameter if you specify `NextToken`.
#' @param MaxResults The maximum number of shards to return in a single call to `ListShards`.
#' The minimum value you can specify for this parameter is 1, and the
#' maximum is 1,000, which is also the default.
#' 
#' When the number of shards to be listed is greater than the value of
#' `MaxResults`, the response contains a `NextToken` value that you can use
#' in a subsequent call to `ListShards` to list the next set of shards.
#' @param StreamCreationTimestamp Specify this input parameter to distinguish data streams that have the
#' same name. For example, if you create a data stream and then delete it,
#' and you later create another data stream with the same name, you can use
#' this input parameter to specify which of the two streams you want to
#' list the shards for.
#' 
#' You cannot specify this parameter if you specify the `NextToken`
#' parameter.
#'
#' @section Request syntax:
#' ```
#' svc$list_shards(
#'   StreamName = "string",
#'   NextToken = "string",
#'   ExclusiveStartShardId = "string",
#'   MaxResults = 123,
#'   StreamCreationTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_list_shards
kinesis_list_shards <- function(StreamName = NULL, NextToken = NULL, ExclusiveStartShardId = NULL, MaxResults = NULL, StreamCreationTimestamp = NULL) {
  op <- new_operation(
    name = "ListShards",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$list_shards_input(StreamName = StreamName, NextToken = NextToken, ExclusiveStartShardId = ExclusiveStartShardId, MaxResults = MaxResults, StreamCreationTimestamp = StreamCreationTimestamp)
  output <- .kinesis$list_shards_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$list_shards <- kinesis_list_shards

#' Lists the consumers registered to receive data from a stream using
#' enhanced fan-out, and provides information about each consumer
#'
#' Lists the consumers registered to receive data from a stream using
#' enhanced fan-out, and provides information about each consumer.
#' 
#' This operation has a limit of 10 transactions per second per account.
#'
#' @usage
#' kinesis_list_stream_consumers(StreamARN, NextToken, MaxResults,
#'   StreamCreationTimestamp)
#'
#' @param StreamARN &#91;required&#93; The ARN of the Kinesis data stream for which you want to list the
#' registered consumers. For more information, see [Amazon Resource Names
#' (ARNs) and AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
#' @param NextToken When the number of consumers that are registered with the data stream is
#' greater than the default value for the `MaxResults` parameter, or if you
#' explicitly specify a value for `MaxResults` that is less than the number
#' of consumers that are registered with the data stream, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to `ListStreamConsumers` to list
#' the next set of registered consumers.
#' 
#' Don\'t specify `StreamName` or `StreamCreationTimestamp` if you specify
#' `NextToken` because the latter unambiguously identifies the stream.
#' 
#' You can optionally specify a value for the `MaxResults` parameter when
#' you specify `NextToken`. If you specify a `MaxResults` value that is
#' less than the number of consumers that the operation returns if you
#' don\'t specify `MaxResults`, the response will contain a new `NextToken`
#' value. You can use the new `NextToken` value in a subsequent call to the
#' `ListStreamConsumers` operation to list the next set of consumers.
#' 
#' Tokens expire after 300 seconds. When you obtain a value for `NextToken`
#' in the response to a call to `ListStreamConsumers`, you have 300 seconds
#' to use that value. If you specify an expired token in a call to
#' `ListStreamConsumers`, you get `ExpiredNextTokenException`.
#' @param MaxResults The maximum number of consumers that you want a single call of
#' `ListStreamConsumers` to return.
#' @param StreamCreationTimestamp Specify this input parameter to distinguish data streams that have the
#' same name. For example, if you create a data stream and then delete it,
#' and you later create another data stream with the same name, you can use
#' this input parameter to specify which of the two streams you want to
#' list the consumers for.
#' 
#' You can\'t specify this parameter if you specify the NextToken
#' parameter.
#'
#' @section Request syntax:
#' ```
#' svc$list_stream_consumers(
#'   StreamARN = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   StreamCreationTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_list_stream_consumers
kinesis_list_stream_consumers <- function(StreamARN, NextToken = NULL, MaxResults = NULL, StreamCreationTimestamp = NULL) {
  op <- new_operation(
    name = "ListStreamConsumers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$list_stream_consumers_input(StreamARN = StreamARN, NextToken = NextToken, MaxResults = MaxResults, StreamCreationTimestamp = StreamCreationTimestamp)
  output <- .kinesis$list_stream_consumers_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$list_stream_consumers <- kinesis_list_stream_consumers

#' Lists your Kinesis data streams
#'
#' Lists your Kinesis data streams.
#' 
#' The number of streams may be too large to return from a single call to
#' `ListStreams`. You can limit the number of returned streams using the
#' `Limit` parameter. If you do not specify a value for the `Limit`
#' parameter, Kinesis Data Streams uses the default limit, which is
#' currently 10.
#' 
#' You can detect if there are more streams available to list by using the
#' `HasMoreStreams` flag from the returned output. If there are more
#' streams available, you can request more streams by using the name of the
#' last stream returned by the `ListStreams` request in the
#' `ExclusiveStartStreamName` parameter in a subsequent request to
#' `ListStreams`. The group of stream names returned by the subsequent
#' request is then added to the list. You can continue this process until
#' all the stream names have been collected in the list.
#' 
#' ListStreams has a limit of five transactions per second per account.
#'
#' @usage
#' kinesis_list_streams(Limit, ExclusiveStartStreamName)
#'
#' @param Limit The maximum number of streams to list.
#' @param ExclusiveStartStreamName The name of the stream to start the list with.
#'
#' @section Request syntax:
#' ```
#' svc$list_streams(
#'   Limit = 123,
#'   ExclusiveStartStreamName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_list_streams
kinesis_list_streams <- function(Limit = NULL, ExclusiveStartStreamName = NULL) {
  op <- new_operation(
    name = "ListStreams",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$list_streams_input(Limit = Limit, ExclusiveStartStreamName = ExclusiveStartStreamName)
  output <- .kinesis$list_streams_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$list_streams <- kinesis_list_streams

#' Lists the tags for the specified Kinesis data stream
#'
#' Lists the tags for the specified Kinesis data stream. This operation has
#' a limit of five transactions per second per account.
#'
#' @usage
#' kinesis_list_tags_for_stream(StreamName, ExclusiveStartTagKey, Limit)
#'
#' @param StreamName &#91;required&#93; The name of the stream.
#' @param ExclusiveStartTagKey The key to use as the starting point for the list of tags. If this
#' parameter is set, `ListTagsForStream` gets all tags that occur after
#' `ExclusiveStartTagKey`.
#' @param Limit The number of tags to return. If this number is less than the total
#' number of tags associated with the stream, `HasMoreTags` is set to
#' `true`. To list additional tags, set `ExclusiveStartTagKey` to the last
#' key in the response.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_stream(
#'   StreamName = "string",
#'   ExclusiveStartTagKey = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_list_tags_for_stream
kinesis_list_tags_for_stream <- function(StreamName, ExclusiveStartTagKey = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTagsForStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$list_tags_for_stream_input(StreamName = StreamName, ExclusiveStartTagKey = ExclusiveStartTagKey, Limit = Limit)
  output <- .kinesis$list_tags_for_stream_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$list_tags_for_stream <- kinesis_list_tags_for_stream

#' Merges two adjacent shards in a Kinesis data stream and combines them
#' into a single shard to reduce the stream's capacity to ingest and
#' transport data
#'
#' Merges two adjacent shards in a Kinesis data stream and combines them
#' into a single shard to reduce the stream\'s capacity to ingest and
#' transport data. Two shards are considered adjacent if the union of the
#' hash key ranges for the two shards form a contiguous set with no gaps.
#' For example, if you have two shards, one with a hash key range of
#' 276\\...381 and the other with a hash key range of 382\\...454, then you
#' could merge these two shards into a single shard that would have a hash
#' key range of 276\\...454. After the merge, the single child shard
#' receives data for all hash key values covered by the two parent shards.
#' 
#' `MergeShards` is called when there is a need to reduce the overall
#' capacity of a stream because of excess capacity that is not being used.
#' You must specify the shard to be merged and the adjacent shard for a
#' stream. For more information about merging shards, see [Merge Two
#' Shards](http://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-resharding-merge.html)
#' in the *Amazon Kinesis Data Streams Developer Guide*.
#' 
#' If the stream is in the `ACTIVE` state, you can call `MergeShards`. If a
#' stream is in the `CREATING`, `UPDATING`, or `DELETING` state,
#' `MergeShards` returns a `ResourceInUseException`. If the specified
#' stream does not exist, `MergeShards` returns a
#' `ResourceNotFoundException`.
#' 
#' You can use DescribeStream to check the state of the stream, which is
#' returned in `StreamStatus`.
#' 
#' `MergeShards` is an asynchronous operation. Upon receiving a
#' `MergeShards` request, Amazon Kinesis Data Streams immediately returns a
#' response and sets the `StreamStatus` to `UPDATING`. After the operation
#' is completed, Kinesis Data Streams sets the `StreamStatus` to `ACTIVE`.
#' Read and write operations continue to work while the stream is in the
#' `UPDATING` state.
#' 
#' You use DescribeStream to determine the shard IDs that are specified in
#' the `MergeShards` request.
#' 
#' If you try to operate on too many streams in parallel using
#' CreateStream, DeleteStream, `MergeShards`, or SplitShard, you receive a
#' `LimitExceededException`.
#' 
#' `MergeShards` has a limit of five transactions per second per account.
#'
#' @usage
#' kinesis_merge_shards(StreamName, ShardToMerge, AdjacentShardToMerge)
#'
#' @param StreamName &#91;required&#93; The name of the stream for the merge.
#' @param ShardToMerge &#91;required&#93; The shard ID of the shard to combine with the adjacent shard for the
#' merge.
#' @param AdjacentShardToMerge &#91;required&#93; The shard ID of the adjacent shard for the merge.
#'
#' @section Request syntax:
#' ```
#' svc$merge_shards(
#'   StreamName = "string",
#'   ShardToMerge = "string",
#'   AdjacentShardToMerge = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_merge_shards
kinesis_merge_shards <- function(StreamName, ShardToMerge, AdjacentShardToMerge) {
  op <- new_operation(
    name = "MergeShards",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$merge_shards_input(StreamName = StreamName, ShardToMerge = ShardToMerge, AdjacentShardToMerge = AdjacentShardToMerge)
  output <- .kinesis$merge_shards_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$merge_shards <- kinesis_merge_shards

#' Writes a single data record into an Amazon Kinesis data stream
#'
#' Writes a single data record into an Amazon Kinesis data stream. Call
#' `PutRecord` to send data into the stream for real-time ingestion and
#' subsequent processing, one record at a time. Each shard can support
#' writes up to 1,000 records per second, up to a maximum data write total
#' of 1 MB per second.
#' 
#' You must specify the name of the stream that captures, stores, and
#' transports the data; a partition key; and the data blob itself.
#' 
#' The data blob can be any type of data; for example, a segment from a log
#' file, geographic/location data, website clickstream data, and so on.
#' 
#' The partition key is used by Kinesis Data Streams to distribute data
#' across shards. Kinesis Data Streams segregates the data records that
#' belong to a stream into multiple shards, using the partition key
#' associated with each data record to determine the shard to which a given
#' data record belongs.
#' 
#' Partition keys are Unicode strings, with a maximum length limit of 256
#' characters for each key. An MD5 hash function is used to map partition
#' keys to 128-bit integer values and to map associated data records to
#' shards using the hash key ranges of the shards. You can override hashing
#' the partition key to determine the shard by explicitly specifying a hash
#' value using the `ExplicitHashKey` parameter. For more information, see
#' [Adding Data to a
#' Stream](http://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream)
#' in the *Amazon Kinesis Data Streams Developer Guide*.
#' 
#' `PutRecord` returns the shard ID of where the data record was placed and
#' the sequence number that was assigned to the data record.
#' 
#' Sequence numbers increase over time and are specific to a shard within a
#' stream, not across all shards within a stream. To guarantee strictly
#' increasing ordering, write serially to a shard and use the
#' `SequenceNumberForOrdering` parameter. For more information, see [Adding
#' Data to a
#' Stream](http://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream)
#' in the *Amazon Kinesis Data Streams Developer Guide*.
#' 
#' If a `PutRecord` request cannot be processed because of insufficient
#' provisioned throughput on the shard involved in the request, `PutRecord`
#' throws `ProvisionedThroughputExceededException`.
#' 
#' By default, data records are accessible for 24 hours from the time that
#' they are added to a stream. You can use IncreaseStreamRetentionPeriod or
#' DecreaseStreamRetentionPeriod to modify this retention period.
#'
#' @usage
#' kinesis_put_record(StreamName, Data, PartitionKey, ExplicitHashKey,
#'   SequenceNumberForOrdering)
#'
#' @param StreamName &#91;required&#93; The name of the stream to put the data record into.
#' @param Data &#91;required&#93; The data blob to put into the record, which is base64-encoded when the
#' blob is serialized. When the data blob (the payload before
#' base64-encoding) is added to the partition key size, the total size must
#' not exceed the maximum record size (1 MB).
#' @param PartitionKey &#91;required&#93; Determines which shard in the stream the data record is assigned to.
#' Partition keys are Unicode strings with a maximum length limit of 256
#' characters for each key. Amazon Kinesis Data Streams uses the partition
#' key as input to a hash function that maps the partition key and
#' associated data to a specific shard. Specifically, an MD5 hash function
#' is used to map partition keys to 128-bit integer values and to map
#' associated data records to shards. As a result of this hashing
#' mechanism, all data records with the same partition key map to the same
#' shard within the stream.
#' @param ExplicitHashKey The hash value used to explicitly determine the shard the data record is
#' assigned to by overriding the partition key hash.
#' @param SequenceNumberForOrdering Guarantees strictly increasing sequence numbers, for puts from the same
#' client and to the same partition key. Usage: set the
#' `SequenceNumberForOrdering` of record *n* to the sequence number of
#' record *n-1* (as returned in the result when putting record *n-1*). If
#' this parameter is not set, records are coarsely ordered based on arrival
#' time.
#'
#' @section Request syntax:
#' ```
#' svc$put_record(
#'   StreamName = "string",
#'   Data = raw,
#'   PartitionKey = "string",
#'   ExplicitHashKey = "string",
#'   SequenceNumberForOrdering = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_put_record
kinesis_put_record <- function(StreamName, Data, PartitionKey, ExplicitHashKey = NULL, SequenceNumberForOrdering = NULL) {
  op <- new_operation(
    name = "PutRecord",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$put_record_input(StreamName = StreamName, Data = Data, PartitionKey = PartitionKey, ExplicitHashKey = ExplicitHashKey, SequenceNumberForOrdering = SequenceNumberForOrdering)
  output <- .kinesis$put_record_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$put_record <- kinesis_put_record

#' Writes multiple data records into a Kinesis data stream in a single call
#' (also referred to as a PutRecords request)
#'
#' Writes multiple data records into a Kinesis data stream in a single call
#' (also referred to as a `PutRecords` request). Use this operation to send
#' data into the stream for data ingestion and processing.
#' 
#' Each `PutRecords` request can support up to 500 records. Each record in
#' the request can be as large as 1 MB, up to a limit of 5 MB for the
#' entire request, including partition keys. Each shard can support writes
#' up to 1,000 records per second, up to a maximum data write total of 1 MB
#' per second.
#' 
#' You must specify the name of the stream that captures, stores, and
#' transports the data; and an array of request `Records`, with each record
#' in the array requiring a partition key and data blob. The record size
#' limit applies to the total size of the partition key and data blob.
#' 
#' The data blob can be any type of data; for example, a segment from a log
#' file, geographic/location data, website clickstream data, and so on.
#' 
#' The partition key is used by Kinesis Data Streams as input to a hash
#' function that maps the partition key and associated data to a specific
#' shard. An MD5 hash function is used to map partition keys to 128-bit
#' integer values and to map associated data records to shards. As a result
#' of this hashing mechanism, all data records with the same partition key
#' map to the same shard within the stream. For more information, see
#' [Adding Data to a
#' Stream](http://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream)
#' in the *Amazon Kinesis Data Streams Developer Guide*.
#' 
#' Each record in the `Records` array may include an optional parameter,
#' `ExplicitHashKey`, which overrides the partition key to shard mapping.
#' This parameter allows a data producer to determine explicitly the shard
#' where the record is stored. For more information, see [Adding Multiple
#' Records with
#' PutRecords](http://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-putrecords)
#' in the *Amazon Kinesis Data Streams Developer Guide*.
#' 
#' The `PutRecords` response includes an array of response `Records`. Each
#' record in the response array directly correlates with a record in the
#' request array using natural ordering, from the top to the bottom of the
#' request and response. The response `Records` array always includes the
#' same number of records as the request array.
#' 
#' The response `Records` array includes both successfully and
#' unsuccessfully processed records. Kinesis Data Streams attempts to
#' process all records in each `PutRecords` request. A single record
#' failure does not stop the processing of subsequent records.
#' 
#' A successfully processed record includes `ShardId` and `SequenceNumber`
#' values. The `ShardId` parameter identifies the shard in the stream where
#' the record is stored. The `SequenceNumber` parameter is an identifier
#' assigned to the put record, unique to all records in the stream.
#' 
#' An unsuccessfully processed record includes `ErrorCode` and
#' `ErrorMessage` values. `ErrorCode` reflects the type of error and can be
#' one of the following values: `ProvisionedThroughputExceededException` or
#' `InternalFailure`. `ErrorMessage` provides more detailed information
#' about the `ProvisionedThroughputExceededException` exception including
#' the account ID, stream name, and shard ID of the record that was
#' throttled. For more information about partially successful responses,
#' see [Adding Multiple Records with
#' PutRecords](http://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-add-data-to-stream.html#kinesis-using-sdk-java-putrecords)
#' in the *Amazon Kinesis Data Streams Developer Guide*.
#' 
#' By default, data records are accessible for 24 hours from the time that
#' they are added to a stream. You can use IncreaseStreamRetentionPeriod or
#' DecreaseStreamRetentionPeriod to modify this retention period.
#'
#' @usage
#' kinesis_put_records(Records, StreamName)
#'
#' @param Records &#91;required&#93; The records associated with the request.
#' @param StreamName &#91;required&#93; The stream name associated with the request.
#'
#' @section Request syntax:
#' ```
#' svc$put_records(
#'   Records = list(
#'     list(
#'       Data = raw,
#'       ExplicitHashKey = "string",
#'       PartitionKey = "string"
#'     )
#'   ),
#'   StreamName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_put_records
kinesis_put_records <- function(Records, StreamName) {
  op <- new_operation(
    name = "PutRecords",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$put_records_input(Records = Records, StreamName = StreamName)
  output <- .kinesis$put_records_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$put_records <- kinesis_put_records

#' Registers a consumer with a Kinesis data stream
#'
#' Registers a consumer with a Kinesis data stream. When you use this
#' operation, the consumer you register can read data from the stream at a
#' rate of up to 2 MiB per second. This rate is unaffected by the total
#' number of consumers that read from the same stream.
#' 
#' You can register up to 5 consumers per stream. A given consumer can only
#' be registered with one stream.
#' 
#' This operation has a limit of five transactions per second per account.
#'
#' @usage
#' kinesis_register_stream_consumer(StreamARN, ConsumerName)
#'
#' @param StreamARN &#91;required&#93; The ARN of the Kinesis data stream that you want to register the
#' consumer with. For more info, see [Amazon Resource Names (ARNs) and AWS
#' Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
#' @param ConsumerName &#91;required&#93; For a given Kinesis data stream, each consumer must have a unique name.
#' However, consumer names don\'t have to be unique across data streams.
#'
#' @section Request syntax:
#' ```
#' svc$register_stream_consumer(
#'   StreamARN = "string",
#'   ConsumerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_register_stream_consumer
kinesis_register_stream_consumer <- function(StreamARN, ConsumerName) {
  op <- new_operation(
    name = "RegisterStreamConsumer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$register_stream_consumer_input(StreamARN = StreamARN, ConsumerName = ConsumerName)
  output <- .kinesis$register_stream_consumer_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$register_stream_consumer <- kinesis_register_stream_consumer

#' Removes tags from the specified Kinesis data stream
#'
#' Removes tags from the specified Kinesis data stream. Removed tags are
#' deleted and cannot be recovered after this operation successfully
#' completes.
#' 
#' If you specify a tag that does not exist, it is ignored.
#' 
#' RemoveTagsFromStream has a limit of five transactions per second per
#' account.
#'
#' @usage
#' kinesis_remove_tags_from_stream(StreamName, TagKeys)
#'
#' @param StreamName &#91;required&#93; The name of the stream.
#' @param TagKeys &#91;required&#93; A list of tag keys. Each corresponding tag is removed from the stream.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags_from_stream(
#'   StreamName = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_remove_tags_from_stream
kinesis_remove_tags_from_stream <- function(StreamName, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$remove_tags_from_stream_input(StreamName = StreamName, TagKeys = TagKeys)
  output <- .kinesis$remove_tags_from_stream_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$remove_tags_from_stream <- kinesis_remove_tags_from_stream

#' Splits a shard into two new shards in the Kinesis data stream, to
#' increase the stream's capacity to ingest and transport data
#'
#' Splits a shard into two new shards in the Kinesis data stream, to
#' increase the stream\'s capacity to ingest and transport data.
#' `SplitShard` is called when there is a need to increase the overall
#' capacity of a stream because of an expected increase in the volume of
#' data records being ingested.
#' 
#' You can also use `SplitShard` when a shard appears to be approaching its
#' maximum utilization; for example, the producers sending data into the
#' specific shard are suddenly sending more than previously anticipated.
#' You can also call `SplitShard` to increase stream capacity, so that more
#' Kinesis Data Streams applications can simultaneously read data from the
#' stream for real-time processing.
#' 
#' You must specify the shard to be split and the new hash key, which is
#' the position in the shard where the shard gets split in two. In many
#' cases, the new hash key might be the average of the beginning and ending
#' hash key, but it can be any hash key value in the range being mapped
#' into the shard. For more information, see [Split a
#' Shard](http://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-resharding-split.html)
#' in the *Amazon Kinesis Data Streams Developer Guide*.
#' 
#' You can use DescribeStream to determine the shard ID and hash key values
#' for the `ShardToSplit` and `NewStartingHashKey` parameters that are
#' specified in the `SplitShard` request.
#' 
#' `SplitShard` is an asynchronous operation. Upon receiving a `SplitShard`
#' request, Kinesis Data Streams immediately returns a response and sets
#' the stream status to `UPDATING`. After the operation is completed,
#' Kinesis Data Streams sets the stream status to `ACTIVE`. Read and write
#' operations continue to work while the stream is in the `UPDATING` state.
#' 
#' You can use `DescribeStream` to check the status of the stream, which is
#' returned in `StreamStatus`. If the stream is in the `ACTIVE` state, you
#' can call `SplitShard`. If a stream is in `CREATING` or `UPDATING` or
#' `DELETING` states, `DescribeStream` returns a `ResourceInUseException`.
#' 
#' If the specified stream does not exist, `DescribeStream` returns a
#' `ResourceNotFoundException`. If you try to create more shards than are
#' authorized for your account, you receive a `LimitExceededException`.
#' 
#' For the default shard limit for an AWS account, see [Kinesis Data
#' Streams
#' Limits](http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
#' in the *Amazon Kinesis Data Streams Developer Guide*. To increase this
#' limit, [contact AWS
#' Support](http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html).
#' 
#' If you try to operate on too many streams simultaneously using
#' CreateStream, DeleteStream, MergeShards, and/or SplitShard, you receive
#' a `LimitExceededException`.
#' 
#' `SplitShard` has a limit of five transactions per second per account.
#'
#' @usage
#' kinesis_split_shard(StreamName, ShardToSplit, NewStartingHashKey)
#'
#' @param StreamName &#91;required&#93; The name of the stream for the shard split.
#' @param ShardToSplit &#91;required&#93; The shard ID of the shard to split.
#' @param NewStartingHashKey &#91;required&#93; A hash key value for the starting hash key of one of the child shards
#' created by the split. The hash key range for a given shard constitutes a
#' set of ordered contiguous positive integers. The value for
#' `NewStartingHashKey` must be in the range of hash keys being mapped into
#' the shard. The `NewStartingHashKey` hash key value and all higher hash
#' key values in hash key range are distributed to one of the child shards.
#' All the lower hash key values in the range are distributed to the other
#' child shard.
#'
#' @section Request syntax:
#' ```
#' svc$split_shard(
#'   StreamName = "string",
#'   ShardToSplit = "string",
#'   NewStartingHashKey = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_split_shard
kinesis_split_shard <- function(StreamName, ShardToSplit, NewStartingHashKey) {
  op <- new_operation(
    name = "SplitShard",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$split_shard_input(StreamName = StreamName, ShardToSplit = ShardToSplit, NewStartingHashKey = NewStartingHashKey)
  output <- .kinesis$split_shard_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$split_shard <- kinesis_split_shard

#' Enables or updates server-side encryption using an AWS KMS key for a
#' specified stream
#'
#' Enables or updates server-side encryption using an AWS KMS key for a
#' specified stream.
#' 
#' Starting encryption is an asynchronous operation. Upon receiving the
#' request, Kinesis Data Streams returns immediately and sets the status of
#' the stream to `UPDATING`. After the update is complete, Kinesis Data
#' Streams sets the status of the stream back to `ACTIVE`. Updating or
#' applying encryption normally takes a few seconds to complete, but it can
#' take minutes. You can continue to read and write data to your stream
#' while its status is `UPDATING`. Once the status of the stream is
#' `ACTIVE`, encryption begins for records written to the stream.
#' 
#' API Limits: You can successfully apply a new AWS KMS key for server-side
#' encryption 25 times in a rolling 24-hour period.
#' 
#' Note: It can take up to 5 seconds after the stream is in an `ACTIVE`
#' status before all records written to the stream are encrypted. After you
#' enable encryption, you can verify that encryption is applied by
#' inspecting the API response from `PutRecord` or `PutRecords`.
#'
#' @usage
#' kinesis_start_stream_encryption(StreamName, EncryptionType, KeyId)
#'
#' @param StreamName &#91;required&#93; The name of the stream for which to start encrypting records.
#' @param EncryptionType &#91;required&#93; The encryption type to use. The only valid value is `KMS`.
#' @param KeyId &#91;required&#93; The GUID for the customer-managed AWS KMS key to use for encryption.
#' This value can be a globally unique identifier, a fully specified Amazon
#' Resource Name (ARN) to either an alias or a key, or an alias name
#' prefixed by \"alias/\".You can also use a master key owned by Kinesis
#' Data Streams by specifying the alias `aws/kinesis`.
#' 
#' -   Key ARN example:
#'     `arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012`
#' 
#' -   Alias ARN example:
#'     `arn:aws:kms:us-east-1:123456789012:alias/MyAliasName`
#' 
#' -   Globally unique key ID example:
#'     `12345678-1234-1234-1234-123456789012`
#' 
#' -   Alias name example: `alias/MyAliasName`
#' 
#' -   Master key owned by Kinesis Data Streams: `alias/aws/kinesis`
#'
#' @section Request syntax:
#' ```
#' svc$start_stream_encryption(
#'   StreamName = "string",
#'   EncryptionType = "NONE"|"KMS",
#'   KeyId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_start_stream_encryption
kinesis_start_stream_encryption <- function(StreamName, EncryptionType, KeyId) {
  op <- new_operation(
    name = "StartStreamEncryption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$start_stream_encryption_input(StreamName = StreamName, EncryptionType = EncryptionType, KeyId = KeyId)
  output <- .kinesis$start_stream_encryption_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$start_stream_encryption <- kinesis_start_stream_encryption

#' Disables server-side encryption for a specified stream
#'
#' Disables server-side encryption for a specified stream.
#' 
#' Stopping encryption is an asynchronous operation. Upon receiving the
#' request, Kinesis Data Streams returns immediately and sets the status of
#' the stream to `UPDATING`. After the update is complete, Kinesis Data
#' Streams sets the status of the stream back to `ACTIVE`. Stopping
#' encryption normally takes a few seconds to complete, but it can take
#' minutes. You can continue to read and write data to your stream while
#' its status is `UPDATING`. Once the status of the stream is `ACTIVE`,
#' records written to the stream are no longer encrypted by Kinesis Data
#' Streams.
#' 
#' API Limits: You can successfully disable server-side encryption 25 times
#' in a rolling 24-hour period.
#' 
#' Note: It can take up to 5 seconds after the stream is in an `ACTIVE`
#' status before all records written to the stream are no longer subject to
#' encryption. After you disabled encryption, you can verify that
#' encryption is not applied by inspecting the API response from
#' `PutRecord` or `PutRecords`.
#'
#' @usage
#' kinesis_stop_stream_encryption(StreamName, EncryptionType, KeyId)
#'
#' @param StreamName &#91;required&#93; The name of the stream on which to stop encrypting records.
#' @param EncryptionType &#91;required&#93; The encryption type. The only valid value is `KMS`.
#' @param KeyId &#91;required&#93; The GUID for the customer-managed AWS KMS key to use for encryption.
#' This value can be a globally unique identifier, a fully specified Amazon
#' Resource Name (ARN) to either an alias or a key, or an alias name
#' prefixed by \"alias/\".You can also use a master key owned by Kinesis
#' Data Streams by specifying the alias `aws/kinesis`.
#' 
#' -   Key ARN example:
#'     `arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012`
#' 
#' -   Alias ARN example:
#'     `arn:aws:kms:us-east-1:123456789012:alias/MyAliasName`
#' 
#' -   Globally unique key ID example:
#'     `12345678-1234-1234-1234-123456789012`
#' 
#' -   Alias name example: `alias/MyAliasName`
#' 
#' -   Master key owned by Kinesis Data Streams: `alias/aws/kinesis`
#'
#' @section Request syntax:
#' ```
#' svc$stop_stream_encryption(
#'   StreamName = "string",
#'   EncryptionType = "NONE"|"KMS",
#'   KeyId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_stop_stream_encryption
kinesis_stop_stream_encryption <- function(StreamName, EncryptionType, KeyId) {
  op <- new_operation(
    name = "StopStreamEncryption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$stop_stream_encryption_input(StreamName = StreamName, EncryptionType = EncryptionType, KeyId = KeyId)
  output <- .kinesis$stop_stream_encryption_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$stop_stream_encryption <- kinesis_stop_stream_encryption

#' Updates the shard count of the specified stream to the specified number
#' of shards
#'
#' Updates the shard count of the specified stream to the specified number
#' of shards.
#' 
#' Updating the shard count is an asynchronous operation. Upon receiving
#' the request, Kinesis Data Streams returns immediately and sets the
#' status of the stream to `UPDATING`. After the update is complete,
#' Kinesis Data Streams sets the status of the stream back to `ACTIVE`.
#' Depending on the size of the stream, the scaling action could take a few
#' minutes to complete. You can continue to read and write data to your
#' stream while its status is `UPDATING`.
#' 
#' To update the shard count, Kinesis Data Streams performs splits or
#' merges on individual shards. This can cause short-lived shards to be
#' created, in addition to the final shards. We recommend that you double
#' or halve the shard count, as this results in the fewest number of splits
#' or merges.
#' 
#' This operation has the following default limits. By default, you cannot
#' do the following:
#' 
#' -   Scale more than twice per rolling 24-hour period per stream
#' 
#' -   Scale up to more than double your current shard count for a stream
#' 
#' -   Scale down below half your current shard count for a stream
#' 
#' -   Scale up to more than 500 shards in a stream
#' 
#' -   Scale a stream with more than 500 shards down unless the result is
#'     less than 500 shards
#' 
#' -   Scale up to more than the shard limit for your account
#' 
#' For the default limits for an AWS account, see [Streams
#' Limits](http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
#' in the *Amazon Kinesis Data Streams Developer Guide*. To request an
#' increase in the call rate limit, the shard limit for this API, or your
#' overall shard limit, use the [limits
#' form](https://console.aws.amazon.com/support/v1#/case/create?issueType=service-limit-increase&limitType=service-code-kinesis).
#'
#' @usage
#' kinesis_update_shard_count(StreamName, TargetShardCount, ScalingType)
#'
#' @param StreamName &#91;required&#93; The name of the stream.
#' @param TargetShardCount &#91;required&#93; The new number of shards.
#' @param ScalingType &#91;required&#93; The scaling type. Uniform scaling creates shards of equal size.
#'
#' @section Request syntax:
#' ```
#' svc$update_shard_count(
#'   StreamName = "string",
#'   TargetShardCount = 123,
#'   ScalingType = "UNIFORM_SCALING"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesis_update_shard_count
kinesis_update_shard_count <- function(StreamName, TargetShardCount, ScalingType) {
  op <- new_operation(
    name = "UpdateShardCount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesis$update_shard_count_input(StreamName = StreamName, TargetShardCount = TargetShardCount, ScalingType = ScalingType)
  output <- .kinesis$update_shard_count_output()
  svc <- .kinesis$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$update_shard_count <- kinesis_update_shard_count
