% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_create_cluster}
\alias{kafka_create_cluster}
\title{Creates a new MSK cluster}
\usage{
kafka_create_cluster(BrokerNodeGroupInfo, ClientAuthentication,
  ClusterName, ConfigurationInfo, EncryptionInfo, EnhancedMonitoring,
  OpenMonitoring, KafkaVersion, LoggingInfo, NumberOfBrokerNodes, Tags)
}
\arguments{
\item{BrokerNodeGroupInfo}{[required] Information about the broker nodes in the cluster.}

\item{ClientAuthentication}{Includes all client authentication related information.}

\item{ClusterName}{[required] The name of the cluster.}

\item{ConfigurationInfo}{Represents the configuration that you want MSK to use for the brokers in
a cluster.}

\item{EncryptionInfo}{Includes all encryption-related information.}

\item{EnhancedMonitoring}{Specifies the level of monitoring for the MSK cluster. The possible
values are DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and
PER_TOPIC_PER_PARTITION.}

\item{OpenMonitoring}{The settings for open monitoring.}

\item{KafkaVersion}{[required] The version of Apache Kafka.}

\item{LoggingInfo}{}

\item{NumberOfBrokerNodes}{[required] The number of broker nodes in the cluster.}

\item{Tags}{Create tags when creating the cluster.}
}
\value{
A list with the following syntax:\preformatted{list(
  ClusterArn = "string",
  ClusterName = "string",
  State = "ACTIVE"|"CREATING"|"DELETING"|"FAILED"|"HEALING"|"MAINTENANCE"|"REBOOTING_BROKER"|"UPDATING"
)
}
}
\description{
Creates a new MSK cluster.
}
\section{Request syntax}{
\preformatted{svc$create_cluster(
  BrokerNodeGroupInfo = list(
    BrokerAZDistribution = "DEFAULT",
    ClientSubnets = list(
      "string"
    ),
    InstanceType = "string",
    SecurityGroups = list(
      "string"
    ),
    StorageInfo = list(
      EbsStorageInfo = list(
        VolumeSize = 123
      )
    )
  ),
  ClientAuthentication = list(
    Sasl = list(
      Scram = list(
        Enabled = TRUE|FALSE
      )
    ),
    Tls = list(
      CertificateAuthorityArnList = list(
        "string"
      )
    )
  ),
  ClusterName = "string",
  ConfigurationInfo = list(
    Arn = "string",
    Revision = 123
  ),
  EncryptionInfo = list(
    EncryptionAtRest = list(
      DataVolumeKMSKeyId = "string"
    ),
    EncryptionInTransit = list(
      ClientBroker = "TLS"|"TLS_PLAINTEXT"|"PLAINTEXT",
      InCluster = TRUE|FALSE
    )
  ),
  EnhancedMonitoring = "DEFAULT"|"PER_BROKER"|"PER_TOPIC_PER_BROKER"|"PER_TOPIC_PER_PARTITION",
  OpenMonitoring = list(
    Prometheus = list(
      JmxExporter = list(
        EnabledInBroker = TRUE|FALSE
      ),
      NodeExporter = list(
        EnabledInBroker = TRUE|FALSE
      )
    )
  ),
  KafkaVersion = "string",
  LoggingInfo = list(
    BrokerLogs = list(
      CloudWatchLogs = list(
        Enabled = TRUE|FALSE,
        LogGroup = "string"
      ),
      Firehose = list(
        DeliveryStream = "string",
        Enabled = TRUE|FALSE
      ),
      S3 = list(
        Bucket = "string",
        Enabled = TRUE|FALSE,
        Prefix = "string"
      )
    )
  ),
  NumberOfBrokerNodes = 123,
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
