% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_group_membership}
\alias{quicksight_create_group_membership}
\title{Adds an Amazon QuickSight user to an Amazon QuickSight group}
\usage{
quicksight_create_group_membership(MemberName, GroupName, AwsAccountId,
  Namespace)
}
\arguments{
\item{MemberName}{[required] The name of the user that you want to add to the group membership.}

\item{GroupName}{[required] The name of the group that you want to add the user to.}

\item{AwsAccountId}{[required] The ID for the AWS account that the group is in. Currently, you use the
ID for the AWS account that contains your Amazon QuickSight account.}

\item{Namespace}{[required] The namespace. Currently, you should set this to \code{default}.}
}
\value{
A list with the following syntax:\preformatted{list(
  GroupMember = list(
    Arn = "string",
    MemberName = "string"
  ),
  RequestId = "string",
  Status = 123
)
}
}
\description{
Adds an Amazon QuickSight user to an Amazon QuickSight group.
}
\section{Request syntax}{
\preformatted{svc$create_group_membership(
  MemberName = "string",
  GroupName = "string",
  AwsAccountId = "string",
  Namespace = "string"
)
}
}

\keyword{internal}
