% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_list_security_configurations}
\alias{emr_list_security_configurations}
\title{Lists all the security configurations visible to this account, providing
their creation dates and times, and their names}
\usage{
emr_list_security_configurations(Marker)
}
\arguments{
\item{Marker}{The pagination token that indicates the set of results to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  SecurityConfigurations = list(
    list(
      Name = "string",
      CreationDateTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  Marker = "string"
)
}
}
\description{
Lists all the security configurations visible to this account, providing
their creation dates and times, and their names. This call returns a
maximum of 50 clusters per call, but returns a marker to track the
paging of the cluster list across multiple ListSecurityConfigurations
calls.
}
\section{Request syntax}{
\preformatted{svc$list_security_configurations(
  Marker = "string"
)
}
}

\keyword{internal}
