% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticsearchservice_operations.R
\name{elasticsearchservice_get_package_version_history}
\alias{elasticsearchservice_get_package_version_history}
\title{Returns a list of versions of the package, along with their creation
time and commit message}
\usage{
elasticsearchservice_get_package_version_history(PackageID, MaxResults,
  NextToken)
}
\arguments{
\item{PackageID}{[required] Returns an audit history of versions of the package.}

\item{MaxResults}{Limits results to a maximum number of versions.}

\item{NextToken}{Used for pagination. Only necessary if a previous API call includes a
non-null NextToken value. If provided, returns results for the next
page.}
}
\value{
A list with the following syntax:\preformatted{list(
  PackageID = "string",
  PackageVersionHistoryList = list(
    list(
      PackageVersion = "string",
      CommitMessage = "string",
      CreatedAt = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list of versions of the package, along with their creation
time and commit message.
}
\section{Request syntax}{
\preformatted{svc$get_package_version_history(
  PackageID = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
