% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_delete_group_membership}
\alias{quicksight_delete_group_membership}
\title{Removes a user from a group so that the user is no longer a member of
the group}
\usage{
quicksight_delete_group_membership(MemberName, GroupName, AwsAccountId,
  Namespace)
}
\arguments{
\item{MemberName}{[required] The name of the user that you want to delete from the group membership.}

\item{GroupName}{[required] The name of the group that you want to delete the user from.}

\item{AwsAccountId}{[required] The ID for the AWS account that the group is in. Currently, you use the
ID for the AWS account that contains your Amazon QuickSight account.}

\item{Namespace}{[required] The namespace. Currently, you should set this to \code{default}.}
}
\description{
Removes a user from a group so that the user is no longer a member of
the group.
}
\details{
The permissions resource is
\code{arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> }.

The condition resource is the user name.

The condition key is \code{quicksight:UserName}.

\strong{CLI Sample:}

\code{aws quicksight delete-group-membership --aws-account-id=111122223333 --namespace=default --group-name=Sales-Management --member-name=Charlie }
}
\section{Request syntax}{
\preformatted{svc$delete_group_membership(
  MemberName = "string",
  GroupName = "string",
  AwsAccountId = "string",
  Namespace = "string"
)
}
}

\keyword{internal}
