% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_put_resource_policy}
\alias{glue_put_resource_policy}
\title{Sets the Data Catalog resource policy for access control}
\usage{
glue_put_resource_policy(PolicyInJson, PolicyHashCondition,
  PolicyExistsCondition)
}
\arguments{
\item{PolicyInJson}{[required] Contains the policy document to set, in JSON format.}

\item{PolicyHashCondition}{The hash value returned when the previous policy was set using
\code{PutResourcePolicy}. Its purpose is to prevent concurrent modifications
of a policy. Do not use this parameter if no previous policy has been
set.}

\item{PolicyExistsCondition}{A value of \code{MUST_EXIST} is used to update a policy. A value of
\code{NOT_EXIST} is used to create a new policy. If a value of \code{NONE} or a
null value is used, the call will not depend on the existence of a
policy.}
}
\description{
Sets the Data Catalog resource policy for access control.
}
\section{Request syntax}{
\preformatted{svc$put_resource_policy(
  PolicyInJson = "string",
  PolicyHashCondition = "string",
  PolicyExistsCondition = "MUST_EXIST"|"NOT_EXIST"|"NONE"
)
}
}

\keyword{internal}
