% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_modify_instance_groups}
\alias{emr_modify_instance_groups}
\title{ModifyInstanceGroups modifies the number of nodes and configuration
settings of an instance group}
\usage{
emr_modify_instance_groups(ClusterId, InstanceGroups)
}
\arguments{
\item{ClusterId}{The ID of the cluster to which the instance group belongs.}

\item{InstanceGroups}{Instance groups to change.}
}
\description{
ModifyInstanceGroups modifies the number of nodes and configuration
settings of an instance group. The input parameters include the new
target instance count for the group and the instance group ID. The call
will either succeed or fail atomically.
}
\section{Request syntax}{
\preformatted{svc$modify_instance_groups(
  ClusterId = "string",
  InstanceGroups = list(
    list(
      InstanceGroupId = "string",
      InstanceCount = 123,
      EC2InstanceIdsToTerminate = list(
        "string"
      ),
      ShrinkPolicy = list(
        DecommissionTimeout = 123,
        InstanceResizePolicy = list(
          InstancesToTerminate = list(
            "string"
          ),
          InstancesToProtect = list(
            "string"
          ),
          InstanceTerminationTimeout = 123
        )
      )
    )
  )
)
}
}

\keyword{internal}
