% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procspec.R
\name{procspec}
\alias{procspec}
\title{Process spectra}
\usage{
procspec(rspecdata, opt = c("none", "smooth", "maximum", "minimum", "bin",
  "sum", "center"), fixneg = c("none", "addmin", "zero"), span = 0.25,
  bins = 20, ...)
}
\arguments{
\item{rspecdata}{(required) a data frame, possibly an object of class \code{rspec},
with a column with wavelength data, named 'wl', and the remaining column containing
spectra to process.}

\item{opt}{what type of processing options to apply. User can select multiple options
           by providing a vector. Possibilites are:
\itemize{
\item \code{"none"} does not perform any processing (default).
\item \code{"smooth"} applies LOESS smoothing to each spectrum using 
                     \code{\link{loess.smooth}}. Optimal smoothing parameter
                     can be assessed by using \code{\link{plotsmooth}}.
    \item \code{"minimum"} subtracts the minimum from each individual spectra.
    \item \code{"maxmimum"} divides each spectrum by its maximum value.
    \item \code{"sum"} divides each spectrum by summed values.
    \item \code{"bin"} bins each spectrum into specified wavelength ranges. User should
                                 specify.
 \item \code{"center"} centers individual spectra by subtracting mean reflectance from 
                     all values.
}}

\item{fixneg}{how to handle negative values. Possibilities are:
\itemize{ 
\item \code{"none"} does not perform negative value correction (default).
   \item \code{"zero"} sets all negative values to zero.
   \item \code{"addmin"} adds the absolute value of the maximally negative values of each
                          spectra to the reflectance at all other wavelengths (setting
                          the minimum value to zero, but scaling other values accordingly).
}}

\item{span}{sets the smoothing parameter used by \code{loess.smooth}.}

\item{bins}{sets the number of equally sized wavelength bins for \code{opt = "bin"}.}

\item{...}{ignored.}
}
\value{
A data frame of class \code{rspec} with the processed data.
}
\description{
Applies normalization and/or smoothing to spectra for further analysis or plotting.
}
\examples{
\dontrun{
data(teal)
plot(teal, select = 10)

# Smooth data to remove noise
teal.sm <- procspec(teal, opt = 'smooth', span = 0.25)
plot(teal.sm, select = 10)

# Normalize to max of unity
teal.max <- procspec(teal, opt = c('max'), span = 0.25)
plot(teal.max, select = 10)
}

}
\references{
Cuthill, I., Bennett, A. T. D., Partridge, J. & Maier, E. 1999. 
 Plumage reflectance and the objective assessment of avian sexual dichromatism. 
 The American Naturalist, 153, 183-200.

Montgomerie R. 2006. Analyzing colors. In Hill, G.E, and McGraw, 
 K.J., eds. Bird Coloration. Volume 1 Mechanisms and measuremements. Harvard 
 University Press, Cambridge, Massachusetts.
}
\seealso{
\code{\link{loess.smooth}}
}
\author{
Chad Eliason \email{cme16@zips.uakron.edu}
}
