% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patLanW.R
\name{patLanW}
\alias{patLanW}
\title{Extracts color pattern from landmark transformed image using watershed segmentation. This function
works interactively by allowing to pick a starting pixel within each pattern element from which the
watershed will extract the pattern. This function works best for patterns with sharp boundaries.}
\usage{
patLanW(sampleList, landList, IDlist = NULL, adjustCoords = FALSE,
  transformRef = "meanshape", resampleFactor = NULL,
  transformType = "tps", maskOutline = NULL, cartoonID = NULL,
  correct = FALSE, blur = TRUE, sigma = 3, bucketfill = TRUE,
  cleanP = NULL, splitC = NULL, plotTransformed = FALSE,
  plotCorrect = FALSE, plotEdges = FALSE, plotPriority = FALSE,
  plotWS = FALSE, plotBF = FALSE, plotFinal = FALSE)
}
\arguments{
\item{sampleList}{List of RasterStack objects.}

\item{landList}{Landmark list as returned by \code{\link[patternize]{makeList}}.}

\item{IDlist}{List of sample IDs should be specified when masking outline and transformRef
is 'meanshape'.}

\item{adjustCoords}{Adjust landmark coordinates in case they are reversed compared to pixel
coordinates (default = FALSE).}

\item{transformRef}{ID of reference sample for shape to which color patterns will be transformed
to. Can be 'meanshape' for transforming to mean shape of Procrustes analysis.}

\item{resampleFactor}{Integer for downsampling image used by \code{\link{redRes}}.}

\item{transformType}{Transformation type as used by \code{\link[Morpho]{computeTransform}}
(default ='tps').}

\item{maskOutline}{When outline is specified, everything outside of the outline will be masked for
the color extraction (default = NULL).}

\item{cartoonID}{ID of the sample for which the cartoon was drawn and will be used for masking
(should be set when transformRef = 'meanShape').}

\item{correct}{Correct image illumination using a linear model (default = FALSE).}

\item{blur}{Blur image for priority map extraction (default = TRUE).}

\item{sigma}{Size of sigma for Gaussian blurring (default = 5).}

\item{bucketfill}{Use a bucket fill on the background to fill holes (default = TRUE).}

\item{cleanP}{Integer to remove spurious areas with width smaller than cleanP (default = NULL).}

\item{splitC}{Integer to split selected patterns into connected components and remove ones with
areas smaller than splitC (default = NULL).}

\item{plotTransformed}{Plot transformed image (default = FALSE).}

\item{plotCorrect}{Plot corrected image, corrected for illumination using a linear model
(default = FALSE).}

\item{plotEdges}{Plot image gradient (default = FALSE).}

\item{plotPriority}{Plot priority map (default = FALSE).}

\item{plotWS}{Plot watershed result (default = FALSE).}

\item{plotBF}{Plot bucketfill (default = FALSE).}

\item{plotFinal}{Plot extracted patterns (default = FALSE).}
}
\value{
List of raster objects.
}
\description{
Extracts color pattern from landmark transformed image using watershed segmentation. This function
works interactively by allowing to pick a starting pixel within each pattern element from which the
watershed will extract the pattern. This function works best for patterns with sharp boundaries.
}
\examples{

\dontrun{
IDlist <- c('BC0077','BC0071','BC0050','BC0049','BC0004')
prepath <- system.file("extdata",  package = 'patternize')
extension <- '_landmarks_LFW.txt'

landmarkList <- makeList(IDlist, 'landmark', prepath, extension)

extension <- '.jpg'
imageList <- makeList(IDlist, 'image', prepath, extension)

outline_BC0077 <- read.table(paste(system.file("extdata",  package = 'patternize'),
'/BC0077_outline.txt', sep=''), header = FALSE)

rasterList_W <- patLanW(imageList, landmarkList, IDlist, transformRef = 'meanshape',
adjustCoords = TRUE, plotTransformed = FALSE, correct = TRUE, plotCorrect = FALSE, blur = FALSE,
sigma = 2, bucketfill = FALSE, cleanP = 0, splitC = 10, plotPriority = TRUE, plotWS = TRUE,
plotBF = TRUE, plotFinal = TRUE, maskOutline = outline_BC0077, cartoonID = 'BC0077')
}

}
