% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{filterData}
\alias{filterData}
\title{Filter a dataset for records of interest,
for use in the patient profiles.}
\usage{
filterData(
  data,
  subsetData = NULL,
  subsetVar = NULL,
  subsetValue = NULL,
  subjectVar = "USUBJID",
  subjectSubset = NULL,
  subjectSample = NULL,
  seed = 123
)
}
\arguments{
\item{data}{Data.frame with data}

\item{subsetData}{(optional) Data.frame with extra dataset to filter on.
This dataset is filtered, and only records from \code{data} 
with common subject IDs will be retained.\cr
If not specified, \code{data} is used.}

\item{subsetVar}{(optional) String with variable of subset data to filter on.
\code{subsetValue} should be specified too.\cr
If not specified, all records from the subset data are retained.}

\item{subsetValue}{(optional) Character vector with value(s) of interest to
retain in the filtered data.
These values should be available in \code{subsetVar}.\cr
Missing values in the subject variable are not retained 
in the filtered data.}

\item{subjectVar}{String, variable of data (and subset data) with subject ID.}

\item{subjectSubset}{(optional) Character vector with subjects of interest 
(available in \code{subjectVar}), NULL by default.}

\item{subjectSample}{(optional) Integer of length 1
with number of random subject(s) that should be considered,
e.g. to check the created patient profiles for a subset of the data.
By default, all specified subjects are considered (set to NULL).}

\item{seed}{(optional) Integer of length 1 with seed used to select random subjects 
if \code{subjectSample} is specified (123 by default).}
}
\value{
possibly filtered dataset
}
\description{
Data is filtered based on the following workflow:
\enumerate{
\item{The subset dataset (of \code{data} if not specified)
is filtered based on subject variable and value (if specified).
}
\item{If a external subset dataset is specified, only the subject IDs
of this filtered dataset are considered.}
\item{The \code{data} is filtered based on the selected subjects,
from \code{subjectSubset} (if specified) or from step 2.}
\item{The data is filtered based on a random selection of subjects, if
\code{subjectSample} is specified.}
}
This filtering workflow is used for all subject profile visualization
functions of the package.
}
\examples{
library(clinUtils)

data(dataSDTMCDISCP01)
dataAll <- dataSDTMCDISCP01

# keep only a subset of subjects
# (e.g. to visualize specified patient profiles
# before creating them for all subject)
filterData(
	data = dataAll$AE,
	subjectSample = 2
)

# filter based on specified variable/value:
# only adverse events possibly related
filterData(
	data = dataAll$AE,
	subsetVar = "AEREL",
	subsetValue = "POSSIBLE"
)

# filter based on a different dataset:
# keep only adverse events for subjects in a specific treatment arm
filterData(
	data = dataAll$AE,
	subsetData = dataAll$DM,
	subsetVar = "ACTARM",
	subsetValue = "Placebo"
)

# filter based on subjects of interest
filterData(
	data = dataAll$AE,
	subjectSubset = c("01-701-1148", "01-701-1211")
)

}
\author{
Laure Cougnaud
}
