% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_mut_matrix}
\alias{get_mut_matrix}
\title{Converts MAF into mutation matrix.}
\usage{
get_mut_matrix(
  maffile,
  is.TCGA = TRUE,
  mut_fre = 0,
  nonsynonymous = TRUE,
  cut_fisher.pval = 1,
  cut_oddsRatio = 1,
  sur
)
}
\arguments{
\item{maffile}{Input mutation annotation file (MAF) format data. It must be an absolute path or the name relatived to the current working directory.}

\item{is.TCGA}{Is input MAF file from TCGA source. If TRUE uses only first 15 characters from Tumor_Sample_Barcode.}

\item{mut_fre}{A threshold value(zero as the default value). The genes with a given mutation frequency equal or greater than the threshold value are retained for the following analysis.}

\item{nonsynonymous}{Logical,tell if extract the non-synonymous somatic mutations (nonsense mutation, missense mutation, frame-shif indels, splice site, nonstop mutation, translation start site, inframe indels).}

\item{cut_fisher.pval}{The significant cut_off pvalue for the fisher test.}

\item{cut_oddsRatio}{The cut_off oddsRatio for the fisher test,uses to select the geneset with higher mutation frequency in alive sample group.}

\item{sur}{A nx2 data frame of samples' survival data,the first line is samples' survival event and the second line is samples' overall survival.}
}
\value{
The survival-related mutations matrix.
}
\description{
The function `get_mut_matrix` converts mutation annotation file (MAF) format data into a mutations matrix.Then use the fisher exact test to select the geneset with higher mutation frequency in alive sample group.Finally return the higher mutation frequency matrix.
}
\examples{
#get the path of the mutation annotation file and samples' survival data
maf<-system.file("extdata","data_mutations_extended.txt",package = "pathwayTMB")
sur_path<-system.file("extdata","sur.csv",package = "pathwayTMB")
sur<-read.csv(sur_path,header=TRUE,row.names = 1)
#perform the function 'get_mut_matrix'
mut_matrix<-get_mut_matrix(maffile=maf,mut_fre = 0.01,is.TCGA=FALSE,sur=sur)
}
