% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.R
\name{pred}
\alias{pred}
\alias{pred.lm}
\alias{pred.glm}
\alias{pred.gbm}
\alias{pred.pbart}
\alias{pred.wbart}
\title{Obtaining predicted values from fitted models}
\usage{
pred(object, newdata, ...)

\method{pred}{lm}(object, newdata, ...)

\method{pred}{glm}(object, newdata, ...)

\method{pred}{gbm}(object, newdata, method = "OOB", ...)

\method{pred}{pbart}(object, newdata, ...)

\method{pred}{wbart}(object, newdata, ...)
}
\arguments{
\item{object}{a fitted model object, which can be of class \code{lm}, \code{glm}, \code{gbm},
\code{wbart}, or \code{pbart}.}

\item{newdata}{a data frame containing predictor variables.}

\item{...}{additional arguments passed to the \code{predict} methods.}

\item{method}{Method used to determine the optimal number of boosting iterations for \code{gbm} objects.}
}
\value{
a vector of expected outcomes for \code{newdata}
}
\description{
Generic function that returns predicted outcomes from \code{lm}, \code{glm}, \code{gbm}, \code{wbart},
 and \code{pbart} objects with new data.
}
