% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{r_home}
\alias{r_home}
\title{The R home directory}
\usage{
r_home(component = "home", ..., sep = c("/", "\\\\"))
}
\arguments{
\item{component}{\code{"home"} for the root of the R installation directory,
or the name of a subdirectory.}

\item{...}{Further subdirectories passed to \code{file.path}.}

\item{sep}{String separator between directory levels in the output.}
}
\value{
A character vector of paths inside the R installation dir.
}
\description{
Return a path to a file in the R home directory.  A vectorized, standardized
version of \code{R.home}.
}
\note{
The \code{component} argument has special behaviour for the values
"home", "bin", "doc", "etc", "include", "modules", and "share". See the
help page for \code{\link[base]{R.home}}.
}
\examples{
r_home()
r_home("etc", "Rprofile.site")
r_home(c("home", "bin", "share"), c("", "i386", "zoneinfo"))
}
\seealso{
\code{\link[base]{R.home}}
}
