% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_slice.R
\name{region_slice}
\alias{region_slice}
\title{Extract a climate slice for a region}
\usage{
region_slice(
  time_bp,
  bio_variables,
  dataset,
  path_to_nc = NULL,
  ext = NULL,
  crop = NULL
)
}
\arguments{
\item{time_bp}{the time slice in years before present (negative
values represent
time before present, positive values time in the future). The slice needs
to exist in the dataset. To check which slices are available, you can use
\code{\link[=get_time_steps]{get_time_steps()}}.}

\item{bio_variables}{vector of names of variables to be extracted}

\item{dataset}{string defining the dataset to use. If set to "custom",
then a single nc file is used from "path_to_nc"}

\item{path_to_nc}{the path to the custom nc file containing the palaeoclimate
reconstructions. All the variables of interest need to be included
in this file.}

\item{ext}{an extent, coded as numeric vector (length=4;
order= xmin, xmax, ymin, ymax) or a \link[terra:SpatExtent-class]{terra::SpatExtent} object. If NULL,
the full extent of the reconstruction is given.}

\item{crop}{a polygon used to crop the reconstructions (e.g. the outline
of a continental mass). A \code{\link[sf:st]{sf::sfg}} or a \link[terra:SpatVector-class]{terra::SpatVector} object
is used to define the polygon.}
}
\value{
a
SpatRaster \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} object, with
each variable as a layer.
}
\description{
This function extracts a slice of one or more climate variables for a given
dataset covering a region (or the whole world). The function returns a
SpatRaster \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} object, with
each variable as a layer.
}
