% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{mirkinMetric}
\alias{mirkinMetric}
\alias{mirkinMetric,Partition,Partition-method}
\alias{mirkinMetric,PairCoefficients,missing-method}
\title{Mirkin Metric}
\usage{
mirkinMetric(p, q)

\S4method{mirkinMetric}{Partition,Partition}(p, q)

\S4method{mirkinMetric}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the Mirkin metric
\deqn{2(N_{10} + N_{01})}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
mirkinMetric(new("Partition", c(0, 0, 0, 1, 1)), 
             new("Partition", c(0, 0, 1, 1, 1))) == 8

}
\references{
\insertRef{Mirkin1970}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
